/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network.payload;

import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.gating.GateClientCache;
import net.bandit.reskillable.common.gating.SkillLevelGate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public record SyncGateStatus(int skillIndex, boolean blocked, Component missing) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"reskillable", (String)"sync_gate_status");
    public static final CustomPacketPayload.Type<SyncGateStatus> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncGateStatus> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SyncGateStatus::skillIndex, (StreamCodec)ByteBufCodecs.BOOL, SyncGateStatus::blocked, (StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC, SyncGateStatus::missing, SyncGateStatus::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void send(ServerPlayer player, Skill skill) {
        SkillModel model = SkillModel.get((Player)player);
        if (model == null) {
            return;
        }
        int level = model.getSkillLevel(skill);
        SkillLevelGate.GateResult gate = SkillLevelGate.check(player, model, skill, level);
        boolean blocked = !gate.allowed();
        MutableComponent missing = blocked ? gate.missingListComponent() : Component.empty();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncGateStatus(skill.index, blocked, (Component)missing), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendAll(ServerPlayer player) {
        for (Skill s : Skill.values()) {
            SyncGateStatus.send(player, s);
        }
    }

    public static void handleClient(SyncGateStatus msg) {
        if (msg.skillIndex < 0 || msg.skillIndex >= Skill.values().length) {
            return;
        }
        Skill skill = Skill.values()[msg.skillIndex];
        GateClientCache.set(skill, msg.blocked, msg.missing);
    }
}

