/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.compat;

import com.xiaoyue.celestial_forge.CelestialForge;
import com.xiaoyue.celestial_forge.compat.ReinforceRecipeCategory;
import com.xiaoyue.celestial_forge.compat.ReinforceRecipeWrapper;
import com.xiaoyue.celestial_forge.content.reinforce.IReinforce;
import com.xiaoyue.celestial_forge.register.CFFlags;
import com.xiaoyue.celestial_forge.register.CFItems;
import com.xiaoyue.celestial_forge.utils.ModifierUtils;
import java.util.ArrayList;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;

@JeiPlugin
public class CFJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = CelestialForge.loc("main");
    private static final ReinforceRecipeCategory REINFORCE = new ReinforceRecipeCategory();

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{REINFORCE.init(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(Items.f_42775_.m_7968_(), new RecipeType[]{REINFORCE.getRecipeType()});
    }

    private boolean checkMat(Ingredient ingredient) {
        if (ingredient.m_43947_()) {
            return false;
        }
        for (ItemStack stack : ingredient.m_43908_()) {
            if (!stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList list = new ArrayList();
        CFFlags.DATA_MAP.values().forEach(ref -> {
            if (this.checkMat(ref.temp()) && this.checkMat(ref.mate())) {
                list.add(new ReinforceRecipeWrapper(ref.temp(), ref.mate(), (IReinforce)ref));
            }
        });
        registration.addRecipes(REINFORCE.getRecipeType(), list);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(SmithingScreen.class, 68, 49, 22, 15, new RecipeType[]{REINFORCE.getRecipeType()});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)CFItems.MODIFIER_BOOK.get(), (stack, ctx) -> Optional.ofNullable(ModifierUtils.fromBook(stack)).map(e -> e.id().toString()).orElse("null"));
    }
}

