/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.content.block;

import com.xiaoyue.celestial_forge.content.block.ForgeTableBlockContainer;
import com.xiaoyue.celestial_forge.content.data.ModifierDataHolder;
import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.content.data.UpgradeRecipe;
import com.xiaoyue.celestial_forge.content.modifier.ModifierInstance;
import com.xiaoyue.celestial_forge.content.overlay.InfoTile;
import com.xiaoyue.celestial_forge.content.overlay.TileTooltip;
import com.xiaoyue.celestial_forge.data.CFLang;
import com.xiaoyue.celestial_forge.register.CFItems;
import com.xiaoyue.celestial_forge.utils.ModifierUtils;
import com.xiaoyue.celestial_forge.utils.TypeTestUtils;
import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2library.base.tile.BaseContainerListener;
import dev.xkmc.l2modularblock.tile_api.BlockContainer;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class ForgeTableBlockEntity
extends BaseBlockEntity
implements BaseContainerListener,
BlockContainer,
InfoTile,
IItemHandler {
    @SerialClass.SerialField
    private final ForgeTableBlockContainer container = (ForgeTableBlockContainer)((ForgeTableBlockContainer)new ForgeTableBlockContainer().add(this)).setMax(1);

    public ForgeTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public List<Container> getContainers() {
        return List.of(this.container);
    }

    public void notifyTile() {
        this.sync();
        this.m_6596_();
    }

    public ItemStack get(int i) {
        return this.container.m_8020_(i);
    }

    public void popAllItems(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        BlockPos pos = this.m_58899_().m_7494_();
        for (ItemStack stack : this.container.getAsList()) {
            Block.m_49840_((Level)this.f_58857_, (BlockPos)pos, (ItemStack)stack.m_41777_());
        }
        this.container.m_6211_();
    }

    @Nullable
    public UpgradeRecipe getRecipe(ItemStack stack) {
        if (this.f_58857_ == null) {
            return null;
        }
        if (stack.m_41619_()) {
            return null;
        }
        ModifierType type = TypeTestUtils.getType(stack, this.f_58857_.m_5776_());
        if (type == null) {
            return null;
        }
        ModifierInstance ins = ModifierUtils.getModifier(stack);
        if (ins == null) {
            return ModifierDataHolder.getStart(type);
        }
        if (!ins.needUpgrade()) {
            return null;
        }
        return ins.getNextUpgrade();
    }

    public boolean canAccept(ItemStack stack) {
        ItemStack main = this.get(0);
        if (main.m_41619_()) {
            return this.getRecipe(stack) != null;
        }
        UpgradeRecipe recipe = this.getRecipe(main);
        if (recipe == null) {
            return false;
        }
        for (int i = 0; i < recipe.items.size(); ++i) {
            if (!this.get(i + 1).m_41619_() || !recipe.items.get(i).test(stack)) continue;
            return true;
        }
        return false;
    }

    public void addItem(ItemStack stack) {
        UpgradeRecipe recipe;
        if (this.get(0).m_41619_()) {
            this.container.m_6836_(0, stack);
        }
        if ((recipe = this.getRecipe(this.get(0))) == null) {
            return;
        }
        for (int i = 0; i < recipe.items.size(); ++i) {
            if (!this.get(i + 1).m_41619_() || !recipe.items.get(i).test(stack)) continue;
            this.container.m_6836_(i + 1, stack);
            break;
        }
    }

    @Override
    public TileTooltip getImage() {
        boolean exp;
        UpgradeRecipe recipe = this.getRecipe(this.get(0));
        if (this.f_58857_ == null || recipe == null) {
            return null;
        }
        long index = this.f_58857_.m_46467_() / 20L;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < recipe.items.size(); ++i) {
            Ingredient e = recipe.items.get(i);
            if (!this.get(i + 1).m_41619_()) continue;
            ItemStack[] arr = e.m_43908_();
            list.add(arr[(int)(index % (long)arr.length)]);
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean bl = exp = player != null && (player.f_36078_ >= recipe.exp || player.m_150110_().f_35937_);
        if (exp && list.isEmpty()) {
            list.add(CFItems.HAMMER.asStack());
        }
        if (list.isEmpty()) {
            return null;
        }
        return new TileTooltip(list);
    }

    @Override
    public List<Component> lines() {
        ItemStack main = this.get(0);
        if (main.m_41619_()) {
            return List.of(CFLang.TABLE_START.get(new Object[0]));
        }
        UpgradeRecipe recipe = this.getRecipe(main);
        if (recipe == null) {
            return List.of(CFLang.TABLE_INVALID_ITEM.get(new Object[0]));
        }
        int valid = 0;
        for (int i = 0; i < recipe.items.size(); ++i) {
            if (this.get(i + 1).m_41619_()) continue;
            ++valid;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean exp = player != null && (player.f_36078_ >= recipe.exp || player.m_150110_().f_35937_);
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)CFLang.TABLE_EXP_COST.get(Component.m_237113_((String)("" + recipe.exp))).m_130940_(exp ? ChatFormatting.AQUA : ChatFormatting.RED));
        if (valid == recipe.items.size()) {
            if (exp) {
                list.add((Component)CFLang.TABLE_HAMMER.get(new Object[0]));
            }
            return list;
        }
        list.add((Component)CFLang.TABLE_MATERIAL.get(new Object[0]));
        return list;
    }

    public void activate(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ItemStack main = this.get(0);
        if (main.m_41619_()) {
            return;
        }
        UpgradeRecipe recipe = this.getRecipe(main);
        if (recipe == null) {
            return;
        }
        if (!player.m_150110_().f_35937_ && player.f_36078_ < recipe.exp) {
            return;
        }
        for (int i = 0; i < recipe.items.size(); ++i) {
            if (!this.get(i + 1).m_41619_()) continue;
            return;
        }
        player.m_6749_(-recipe.exp);
        ModifierInstance ins = ModifierUtils.getModifier(main);
        if (ins == null) {
            ins = ModifierUtils.rollModifier(main, this.f_58857_.m_213780_());
            if (ins == null) {
                return;
            }
        } else {
            ins = ins.upgrade();
        }
        main = main.m_41777_();
        ModifierUtils.setModifier(main, ins);
        this.container.m_6211_();
        Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_().m_7494_(), (ItemStack)main);
        this.f_58857_.m_46796_(1030, this.m_58899_(), 0);
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.canAccept(stack)) {
            return stack;
        }
        ItemStack ans = stack.m_41777_();
        ItemStack toInsert = ans.m_41620_(1);
        if (!simulate) {
            this.addItem(toInsert);
        }
        return ans;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.canAccept(stack);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }
}

