/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.content.builder;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.xiaoyue.celestial_forge.CelestialForge;
import com.xiaoyue.celestial_forge.content.builder.UpgradeRecipeBuilder;
import com.xiaoyue.celestial_forge.content.data.LevelingConfig;
import com.xiaoyue.celestial_forge.content.data.ModifierData;
import com.xiaoyue.celestial_forge.content.data.ModifierEntry;
import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.content.data.UpgradeRecipe;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.ConfigDataProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class ModifierDataBuilder {
    private final Map<ResourceLocation, UpgradeRecipe> costs = new LinkedHashMap<ResourceLocation, UpgradeRecipe>();
    private final Map<ResourceLocation, LevelingConfig> levels = new LinkedHashMap<ResourceLocation, LevelingConfig>();
    private final Map<ResourceLocation, ModifierData> modifiers = new LinkedHashMap<ResourceLocation, ModifierData>();

    public TypeBuilder put(ModifierType type, UpgradeRecipeBuilder start) {
        return new TypeBuilder(type, start);
    }

    public void build(ConfigDataProvider.Collector collector) {
        for (Map.Entry<ResourceLocation, UpgradeRecipe> entry : this.costs.entrySet()) {
            collector.add(CelestialForge.COST, entry.getKey(), (BaseConfig)entry.getValue());
        }
        for (Map.Entry<ResourceLocation, BaseConfig> entry : this.levels.entrySet()) {
            collector.add(CelestialForge.LEVELING, entry.getKey(), (BaseConfig)((LevelingConfig)entry.getValue()));
        }
        for (Map.Entry<ResourceLocation, BaseConfig> entry : this.modifiers.entrySet()) {
            collector.add(CelestialForge.MODIFIER, entry.getKey(), (BaseConfig)((ModifierData)entry.getValue()));
        }
    }

    public class TypeBuilder {
        private final ModifierType type;

        public TypeBuilder(ModifierType type, UpgradeRecipeBuilder gate) {
            this.type = type;
            ResourceLocation id = CelestialForge.loc("start/" + type.name().toLowerCase(Locale.ROOT));
            ModifierDataBuilder.this.costs.put(id, gate.build(id, 0));
        }

        public PoolBuilder put(ResourceLocation id, UpgradeRecipeBuilder ... builders) {
            return this.put(id, 125, 0.1, builders);
        }

        public PoolBuilder put(ResourceLocation id, int baseCost, double expCost, UpgradeRecipeBuilder ... builders) {
            int lv = 10;
            for (UpgradeRecipeBuilder e : builders) {
                UpgradeRecipe ans = e.build(id, lv);
                ModifierDataBuilder.this.costs.put(e.loc(id, lv), ans);
                lv += 10;
            }
            return new PoolBuilder(new LevelingConfig(baseCost, expCost, id));
        }

        public ModifierDataBuilder end() {
            return ModifierDataBuilder.this;
        }

        public class PoolBuilder {
            private final ResourceLocation level;

            public PoolBuilder(LevelingConfig config) {
                this.level = config.upgrades();
                ModifierDataBuilder.this.levels.put(this.level, config);
            }

            public PoolBuilder put(ResourceLocation id, int weight, Attribute attr, double base, AttributeModifier.Operation op) {
                return this.put(id, weight, new ModifierEntry(attr, base, op));
            }

            public PoolBuilder put(ResourceLocation id, int weight, ModifierEntry ... entries) {
                CelestialForge.REGISTRATE.addRawLang("modifier." + id.m_135827_() + "." + id.m_135815_(), RegistrateLangProvider.toEnglishName((String)id.m_135815_()));
                ModifierDataBuilder.this.modifiers.put(id, new ModifierData(TypeBuilder.this.type, weight, new ArrayList<ModifierEntry>(List.of(entries)), this.level));
                return this;
            }

            public TypeBuilder end() {
                return TypeBuilder.this;
            }
        }
    }
}

