/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.content.builder;

import com.xiaoyue.celestial_forge.CelestialForge;
import com.xiaoyue.celestial_forge.content.data.DataReinforce;
import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.content.reinforce.AttributeEntry;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.ConfigDataProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ReinforceDataBuilder {
    private final Map<ResourceLocation, DataReinforce> cache = new LinkedHashMap<ResourceLocation, DataReinforce>();

    public Builder builder(String flag) {
        return new Builder(flag);
    }

    public void build(ConfigDataProvider.Collector collector) {
        for (Map.Entry<ResourceLocation, DataReinforce> entry : this.cache.entrySet()) {
            collector.add(CelestialForge.REINFORCE, entry.getKey(), (BaseConfig)entry.getValue());
        }
    }

    public class Builder {
        private final String flag;
        private Ingredient mate;
        private Ingredient temp;
        private final List<ModifierType> types = new ArrayList<ModifierType>();
        private String tooltip = "";
        private final List<AttributeEntry> attrs = new ArrayList<AttributeEntry>();

        public Builder(String flag) {
            this.flag = flag;
        }

        public Builder mate(ItemLike item) {
            this.mate = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
            return this;
        }

        public Builder temp(ItemLike item) {
            this.temp = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
            return this;
        }

        public Builder mate(TagKey<Item> item) {
            this.mate = Ingredient.m_204132_(item);
            return this;
        }

        public Builder temp(TagKey<Item> item) {
            this.temp = Ingredient.m_204132_(item);
            return this;
        }

        public Builder type(ModifierType type) {
            this.types.add(type);
            return this;
        }

        public Builder tooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder attr(Attribute attr, double val, AttributeModifier.Operation operation) {
            this.attrs.add(new AttributeEntry(attr, val, operation));
            return this;
        }

        public ReinforceDataBuilder build() {
            DataReinforce reinforce = new DataReinforce(this.flag, this.temp, this.mate, this.tooltip, this.types, this.attrs);
            ReinforceDataBuilder.this.cache.put(CelestialForge.loc(reinforce.flagName().toLowerCase(Locale.ROOT)), reinforce);
            return ReinforceDataBuilder.this;
        }
    }
}

