/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.content.builder;

import com.xiaoyue.celestial_forge.content.data.UpgradeRecipe;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class UpgradeRecipeBuilder {
    private final int exp;
    private final ArrayList<Ingredient> items;
    private final String altId;

    public UpgradeRecipeBuilder(int exp, ArrayList<Ingredient> items, @Nullable String altId) {
        this.exp = exp;
        this.items = items;
        this.altId = altId;
    }

    public static UpgradeRecipeBuilder of(int exp, Item ... items) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        String altId = null;
        for (Item e : items) {
            String modid;
            list.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{e}));
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)e);
            if (id == null || (modid = id.m_135827_()).equals("minecraft")) continue;
            altId = modid;
        }
        return new UpgradeRecipeBuilder(exp, list, altId);
    }

    public UpgradeRecipe build(ResourceLocation id, int i) {
        return new UpgradeRecipe(id, i, this.exp, this.items);
    }

    public ResourceLocation loc(ResourceLocation id, int lv) {
        return new ResourceLocation(this.altId == null ? id.m_135827_() : this.altId, id.m_135815_() + "/" + lv);
    }
}

