/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.content.data;

import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.content.reinforce.AttributeEntry;
import com.xiaoyue.celestial_forge.content.reinforce.IReinforce;
import com.xiaoyue.celestial_forge.data.CFLang;
import com.xiaoyue.celestial_forge.register.CFFlags;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;

@SerialClass
public class DataReinforce
extends BaseConfig
implements IReinforce {
    @SerialClass.SerialField
    private String flag;
    @SerialClass.SerialField
    private Ingredient mate;
    @SerialClass.SerialField
    private Ingredient temp;
    @SerialClass.SerialField
    private String tooltip;
    @SerialClass.SerialField
    private List<ModifierType> types = new ArrayList<ModifierType>();
    @SerialClass.SerialField
    private List<AttributeEntry> attrs = new ArrayList<AttributeEntry>();

    public DataReinforce(String flag, Ingredient temp, Ingredient mate, String tooltip, List<ModifierType> types, List<AttributeEntry> attrs) {
        this.flag = flag;
        this.temp = temp;
        this.mate = mate;
        this.tooltip = tooltip;
        this.types = types;
        this.attrs = attrs;
    }

    public DataReinforce() {
    }

    public String flagName() {
        return this.flag;
    }

    @Override
    public List<ModifierType> types() {
        return this.types;
    }

    @Override
    public String flag() {
        return CFFlags.flagName(this.flag);
    }

    @Override
    public Ingredient temp() {
        return this.temp;
    }

    @Override
    public Ingredient mate() {
        return this.mate;
    }

    @Override
    public List<Component> tooltip() {
        if (!this.tooltip.isEmpty()) {
            return List.of(Component.m_237115_((String)this.tooltip));
        }
        ArrayList<Component> list = new ArrayList<Component>();
        String key = ForgeRegistries.ITEMS.getKey((Object)this.mate.m_43908_()[0].m_41720_()).toString();
        if (this.attrs.size() > 1) {
            list.add((Component)CFFlags.item(key));
            for (AttributeEntry entry : this.attrs) {
                list.add((Component)CFLang.ATTR_BONUS.get(CFLang.attr(entry.attr()), CFLang.per(entry.val())).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            list.add((Component)CFFlags.item(key, CFLang.ATTR_BONUS.get(CFLang.attr(this.attrs.get(0).attr()), CFLang.per(this.attrs.get(0).val())).m_130940_(ChatFormatting.GRAY)));
        }
        return list;
    }

    public List<AttributeEntry> attrs() {
        return this.attrs;
    }
}

