/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.content.data;

import com.google.common.collect.LinkedHashMultimap;
import com.xiaoyue.celestial_forge.CelestialForge;
import com.xiaoyue.celestial_forge.content.data.LevelingConfig;
import com.xiaoyue.celestial_forge.content.data.ModifierData;
import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.content.data.UpgradeRecipe;
import com.xiaoyue.celestial_forge.content.modifier.LevelingData;
import com.xiaoyue.celestial_forge.content.modifier.ModifierHolder;
import com.xiaoyue.celestial_forge.content.modifier.ModifierPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ModifierDataHolder {
    private static ModifierDataHolder INS;
    private final Map<ResourceLocation, UpgradeRecipe> recipes = new LinkedHashMap<ResourceLocation, UpgradeRecipe>();
    private final Map<ModifierType, ModifierPool> byTypePool = new LinkedHashMap<ModifierType, ModifierPool>();
    private final Map<ResourceLocation, ModifierHolder> byIdCache = new LinkedHashMap<ResourceLocation, ModifierHolder>();

    public static void rebuild() {
        INS = new ModifierDataHolder();
    }

    @Nullable
    public static ModifierHolder byId(ResourceLocation id) {
        return INS == null ? null : ModifierDataHolder.INS.byIdCache.get(id);
    }

    public static ModifierPool byType(ModifierType type) {
        if (INS == null) {
            throw new IllegalStateException("Cannot invoke byType before data is loaded");
        }
        if (type == ModifierType.ALL) {
            throw new IllegalStateException("byType cannot be called for ALL");
        }
        return ModifierDataHolder.INS.byTypePool.get((Object)type);
    }

    @Nullable
    public static UpgradeRecipe getStart(ModifierType type) {
        return INS == null ? null : ModifierDataHolder.INS.recipes.get(CelestialForge.loc("start/" + type.name().toLowerCase(Locale.ROOT)));
    }

    public static Collection<ModifierHolder> all() {
        return INS == null ? List.of() : ModifierDataHolder.INS.byIdCache.values();
    }

    private ModifierDataHolder() {
        for (Object e : CelestialForge.COST.getAll()) {
            ResourceLocation resourceLocation = ((UpgradeRecipe)((Object)e)).level == 0 ? ((UpgradeRecipe)((Object)e)).target() : ((UpgradeRecipe)((Object)e)).target().m_266382_("/" + ((UpgradeRecipe)((Object)e)).level);
            this.recipes.put(resourceLocation, (UpgradeRecipe)((Object)e));
        }
        LinkedHashMultimap subRecipes = LinkedHashMultimap.create();
        for (UpgradeRecipe upgradeRecipe : this.recipes.values()) {
            if (upgradeRecipe.level <= 0) continue;
            subRecipes.put((Object)upgradeRecipe.target(), (Object)upgradeRecipe);
        }
        LinkedHashMap<ResourceLocation, LevelingData> leveling = new LinkedHashMap<ResourceLocation, LevelingData>();
        for (Object e : CelestialForge.LEVELING.getAll()) {
            Collection list = subRecipes.get((Object)((LevelingConfig)((Object)e)).upgrades());
            TreeMap<Integer, UpgradeRecipe> map = new TreeMap<Integer, UpgradeRecipe>();
            for (UpgradeRecipe c : list) {
                map.put(c.level, c);
            }
            leveling.put(e.getID(), new LevelingData(((LevelingConfig)((Object)e)).baseCost(), ((LevelingConfig)((Object)e)).expCost(), map));
        }
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        this.byTypePool.clear();
        this.byIdCache.clear();
        for (ModifierData e : CelestialForge.MODIFIER.getAll()) {
            ModifierType type = e.type();
            LevelingData lv = (LevelingData)leveling.get(e.leveling());
            if (lv == null) {
                CelestialForge.LOGGER.error("Leveling data {} does not exist", (Object)e.leveling());
                continue;
            }
            ModifierHolder holder = new ModifierHolder(type, e.getID(), e, lv);
            this.byIdCache.put(e.getID(), holder);
            linkedHashMultimap.put((Object)type, (Object)holder);
        }
        Collection all = linkedHashMultimap.get((Object)ModifierType.ALL);
        for (ModifierType e : ModifierType.values()) {
            if (e == ModifierType.ALL) continue;
            ArrayList<ModifierHolder> list = new ArrayList<ModifierHolder>();
            list.addAll(linkedHashMultimap.get((Object)e));
            list.addAll(all);
            this.byTypePool.put(e, ModifierPool.construct(e, list));
        }
    }
}

