/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.content.modifier;

import com.xiaoyue.celestial_forge.content.data.ModifierEntry;
import com.xiaoyue.celestial_forge.content.data.UpgradeRecipe;
import com.xiaoyue.celestial_forge.content.modifier.ModifierHolder;
import com.xiaoyue.celestial_forge.content.modifier.ModifierInstanceEntry;
import com.xiaoyue.celestial_forge.data.CFLang;
import com.xiaoyue.celestial_forge.utils.ModifierUtils;
import dev.xkmc.l2damagetracker.contents.curios.AttrTooltip;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public record ModifierInstance(ModifierHolder holder, int level, int exp) {
    public static ModifierInstance of(ModifierHolder ins) {
        return new ModifierInstance(ins, 0, 0);
    }

    @Nullable
    private static MutableComponent getModifierDescription(ModifierInstanceEntry entry) {
        double d1;
        int op = entry.entry().op().m_22235_();
        double d0 = entry.getAmount();
        if (entry.entry().op() == AttributeModifier.Operation.ADDITION) {
            if (entry.entry().attr() == Attributes.f_22278_) {
                d1 = d0 * 10.0;
            } else if (AttrTooltip.isMult((Attribute)entry.entry().attr())) {
                d1 = d0 * 100.0;
                op = AttributeModifier.Operation.MULTIPLY_BASE.m_22235_();
            } else {
                d1 = d0;
            }
        } else {
            d1 = d0 * 100.0;
        }
        if (d0 > 0.0) {
            return Component.m_237110_((String)("attribute.modifier.plus." + op), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)entry.entry().attr().m_22087_())}).m_130940_(ChatFormatting.BLUE);
        }
        if (d0 < 0.0) {
            return Component.m_237110_((String)("attribute.modifier.take." + op), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)entry.entry().attr().m_22087_())}).m_130940_(ChatFormatting.RED);
        }
        return null;
    }

    public List<MutableComponent> extraLines() {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(CFLang.MODIFIER_LEVEL.get(Component.m_237113_((String)("" + this.level)).m_130940_(ChatFormatting.BLUE)).m_130940_(ChatFormatting.GRAY));
        if (this.canUpgrade()) {
            if (this.needUpgrade()) {
                lines.add(CFLang.NEED_UPGRADE.get(new Object[0]).m_130940_(ChatFormatting.YELLOW));
            } else {
                lines.add(CFLang.GRADE_PROGRESS.get(Component.m_237113_((String)("" + this.exp)).m_130940_(ChatFormatting.BLUE), Component.m_237113_((String)("" + ModifierUtils.getMaxExp(this.level))).m_130940_(ChatFormatting.BLUE)).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            lines.add(CFLang.IS_MAX_LEVEL.get(new Object[0]).m_130940_(ChatFormatting.GOLD));
        }
        return lines;
    }

    public List<MutableComponent> getInfoLines() {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(Component.m_237119_());
        int size = this.holder.data().modifiers().size();
        if (size < 1) {
            return lines;
        }
        if (size == 1) {
            MutableComponent description = ModifierInstance.getModifierDescription(new ModifierInstanceEntry(this.holder.data().modifiers().get(0), this.level));
            if (description == null) {
                return lines;
            }
            lines.add(CFLang.CELESTIAL_MODIFIER.get(this.holder.getFormattedName().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            lines.add(description);
        } else {
            lines.add(CFLang.CELESTIAL_MODIFIER.get(this.holder.getFormattedName().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY));
            for (ModifierEntry entry : this.holder.data().modifiers()) {
                MutableComponent description = ModifierInstance.getModifierDescription(new ModifierInstanceEntry(entry, this.level));
                if (description == null) continue;
                lines.add(description);
            }
            if (lines.size() == 1) {
                lines.clear();
            }
        }
        return lines;
    }

    public int size() {
        return this.holder.data().modifiers().size();
    }

    public ModifierInstanceEntry get(int i) {
        return new ModifierInstanceEntry(this.holder.data().modifiers().get(i), this.level);
    }

    public boolean canUpgrade() {
        return this.level < this.holder.gate().upgrades().size() * 10;
    }

    public ModifierInstance addExp(int toAdd) {
        int xp;
        int next;
        int maxLv;
        int lv = this.level;
        int n = maxLv = lv > 0 && lv % 10 == 0 ? lv : lv / 10 * 10 + 10;
        for (xp = toAdd + this.exp; lv < maxLv && xp >= (next = ModifierUtils.getMaxExp(lv)); ++lv, xp -= next) {
        }
        return new ModifierInstance(this.holder, lv, xp);
    }

    public boolean needUpgrade() {
        return this.canUpgrade() && this.level > 0 && this.level % 10 == 0 && this.exp >= ModifierUtils.getMaxExp(this.level);
    }

    public UpgradeRecipe getNextUpgrade() {
        return this.holder.gate().upgrades().get(this.level);
    }

    public ModifierInstance upgrade() {
        if (this.needUpgrade()) {
            return new ModifierInstance(this.holder, this.level + 1, this.exp - ModifierUtils.getMaxExp(this.level));
        }
        return this;
    }
}

