/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.content.reinforce;

import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.utils.CurioUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.server.ServerLifecycleHooks;

public interface IReinforce {
    public static final String itemReinforceName = "CelestialForge_ItemReinforce";

    public String flag();

    default public Ingredient temp() {
        return Ingredient.f_43901_;
    }

    default public Ingredient mate() {
        return Ingredient.f_43901_;
    }

    public List<Component> tooltip();

    public List<ModifierType> types();

    default public boolean isInput(ItemStack item) {
        boolean flag = false;
        for (ModifierType type : this.types()) {
            if (type.equals((Object)ModifierType.ALL)) {
                flag = true;
                break;
            }
            if (!type.test(item, ServerLifecycleHooks.getCurrentServer() == null)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isReinforced(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128471_(itemReinforceName);
        }
        return false;
    }

    default public boolean hasFlag(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128471_(this.flag());
        }
        return false;
    }

    default public List<ItemStack> getItemsForFlag(LivingEntity entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack2 = entity.m_6844_(slot);
            if (stack2.m_41619_() || !this.hasFlag(stack2)) continue;
            list.add(stack2);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CurioUtils.addPlayerSlots(player, stack -> {
                if (!stack.m_41619_() && this.hasFlag((ItemStack)stack)) {
                    list.add((ItemStack)stack);
                }
            });
        }
        return list;
    }
}

