/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.content.reinforce;

import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.content.reinforce.IReinforce;
import com.xiaoyue.celestial_forge.register.CFFlags;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ReinforceData
implements IReinforce {
    private final String flag;
    private final ModifierType[] types;
    @Nullable
    private final ItemLike temp;
    @Nullable
    private final ItemLike mate;
    private final Component tooltip;

    public ReinforceData(String flag, String mate, ItemLike temp, Component tooltip, ModifierType ... types) {
        this.flag = flag;
        this.types = types;
        this.temp = temp;
        this.mate = (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mate));
        this.tooltip = tooltip;
        CFFlags.DATA_MAP.put(flag, this);
    }

    public ReinforceData(String flag, String mate, String temp, Component tooltip, ModifierType ... types) {
        this.flag = flag;
        this.types = types;
        this.temp = (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(temp));
        this.mate = (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mate));
        this.tooltip = tooltip;
        CFFlags.DATA_MAP.put(flag, this);
    }

    @Override
    public String flag() {
        return this.flag;
    }

    @Override
    public List<ModifierType> types() {
        return Arrays.stream(this.types).toList();
    }

    @Override
    @Nullable
    public Ingredient mate() {
        return this.mate == null ? null : Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.mate});
    }

    @Override
    @Nullable
    public Ingredient temp() {
        return this.temp == null ? null : Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.temp});
    }

    @Override
    public List<Component> tooltip() {
        return List.of(this.tooltip);
    }
}

