/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.data;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="celestial_forge", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CFModConfig {
    public static ForgeConfigSpec COMMON_SPEC;
    public static Common COMMON;

    public static void initConfig() {
        String path = "celestial_configs/celestial_forge-common.toml";
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC, path);
    }

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue modifierBookRecipeCost;
        public final ForgeConfigSpec.IntValue modifierBookCraftCost;
        public final ForgeConfigSpec.DoubleValue modifierMaxLevelRate;
        public final ForgeConfigSpec.IntValue modifierMaxLevelBase;
        public final ForgeConfigSpec.IntValue grindstoneRemovalPriorityLevel;
        public final ForgeConfigSpec.IntValue modifierToBookLevel;
        public final ForgeConfigSpec.BooleanValue enableWeaponForging;
        public final ForgeConfigSpec.BooleanValue enableRangedForging;
        public final ForgeConfigSpec.BooleanValue enableArmorForging;
        public final ForgeConfigSpec.BooleanValue enableToolForging;
        public final ForgeConfigSpec.BooleanValue enableCurioForging;
        public final ForgeConfigSpec.DoubleValue echoShardPickExpBonus;
        public final ForgeConfigSpec.DoubleValue earthCoreMiningSpeed;
        public final ForgeConfigSpec.DoubleValue voidEssenceExtraDamage;
        public final ForgeConfigSpec.DoubleValue deathEssenceDamageHeal;
        public final ForgeConfigSpec.DoubleValue pureStarDamageFactor;

        Common(ForgeConfigSpec.Builder builder) {
            this.modifierBookRecipeCost = builder.comment("Experience level that will be consumed when transferring modifier from modifier book to equipment").defineInRange("modifierBookRecipeCost", 22, 1, 100);
            this.modifierBookCraftCost = builder.comment("Experience level that will be consumed when transferring modifier from equipment to modifier book").defineInRange("modifierBookCraftCost", 22, 1, 100);
            this.modifierMaxLevelRate = builder.comment("Experience cost exponential multiplier for modifier upgrading").defineInRange("modifierMaxLevelRate", 0.1, 0.01, 0.5);
            this.modifierMaxLevelBase = builder.comment("Basic experience required for modifier upgrade").defineInRange("modifierMaxLevelBase", 125, 10, 1000);
            this.grindstoneRemovalPriorityLevel = builder.comment("Max level which grindstone will prioritize removing modifier over enchantments").defineInRange("grindstoneRemovalPriorityLevel", 0, 0, 100);
            this.modifierToBookLevel = builder.comment("Min level which modifier can be transferred to modifier book on anvil").defineInRange("modifierToBookLevel", 30, 0, 100);
            this.enableWeaponForging = builder.comment("Enable forging for type Weapon").define("enableWeaponForging", true);
            this.enableRangedForging = builder.comment("Enable forging for type Ranged Weapon").define("enableRangedForging", true);
            this.enableArmorForging = builder.comment("Enable forging for type Armor").define("enableArmorForging", true);
            this.enableToolForging = builder.comment("Enable forging for type Tool").define("enableToolForging", true);
            this.enableCurioForging = builder.comment("Enable forging for type Curio").define("enableCurioForging", true);
            builder.push("reinforce");
            this.echoShardPickExpBonus = builder.comment("Echo Shard Reinforce: pick  exp bonus").defineInRange("echoShardPickExpBonus", 0.03, 0.01, 100.0);
            this.earthCoreMiningSpeed = builder.comment("Earth Core Reinforce: mining speed bonus").defineInRange("earthCoreMiningSpeed", 0.08, 0.01, 100.0);
            this.voidEssenceExtraDamage = builder.comment("Void Essence Reinforce: extra abyss damage").defineInRange("voidEssenceExtraDamage", 2.0, 1.0, 100000.0);
            this.deathEssenceDamageHeal = builder.comment("Death Essence Reinforce: The amount of health regenerated after attacking").defineInRange("deathEssenceDamageHeal", 0.05, 0.01, 100.0);
            this.pureStarDamageFactor = builder.comment("Pure Star Reinforce: percentage damage attached when attacking undead creatures").defineInRange("pureStarDamageFactor", 0.01, 0.01, 1.0);
            builder.pop();
        }
    }
}

