/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.events;

import com.xiaoyue.celestial_core.data.CCDamageTypes;
import com.xiaoyue.celestial_forge.content.data.DataReinforce;
import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.content.reinforce.AttributeEntry;
import com.xiaoyue.celestial_forge.data.CFModConfig;
import com.xiaoyue.celestial_forge.register.CFFlags;
import com.xiaoyue.celestial_forge.utils.TypeTestUtils;
import dev.xkmc.l2library.init.events.GeneralEventHandler;
import dev.xkmc.l2library.util.math.MathHelper;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="celestial_forge", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CFReinforceHandler {
    @SubscribeEvent
    public static void onAttrModify(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        CFFlags.DATA_MAP.values().forEach(data -> {
            if (data instanceof DataReinforce) {
                DataReinforce attrData = (DataReinforce)data;
                ModifierType type = TypeTestUtils.getType(stack);
                if (type == null) {
                    return;
                }
                if (event.getSlotType() == LivingEntity.m_147233_((ItemStack)stack) && data.hasFlag(stack) && type != ModifierType.CURIO) {
                    for (int i = 0; i < attrData.attrs().size(); ++i) {
                        AttributeEntry entry = attrData.attrs().get(i);
                        UUID uuid = MathHelper.getUUIDFromString((String)(data.flag().toLowerCase(Locale.ROOT) + "_" + i));
                        AttributeModifier modifier = new AttributeModifier(uuid, data.flag(), entry.val(), entry.operation());
                        event.addModifier(entry.attr(), modifier);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void onPickExp(PlayerXpEvent.PickupXp event) {
        float bonus = (float)CFFlags.ECHO_SHARD.getItemsForFlag((LivingEntity)event.getEntity()).size() * ((Double)CFModConfig.COMMON.echoShardPickExpBonus.get()).floatValue();
        event.getOrb().f_20770_ = (int)((float)event.getOrb().f_20770_ * (1.0f + bonus));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerBreak(PlayerEvent.BreakSpeed event) {
        float bonus = (float)CFFlags.EARTH_CORE.getItemsForFlag((LivingEntity)event.getEntity()).size() * ((Double)CFModConfig.COMMON.earthCoreMiningSpeed.get()).floatValue();
        event.setNewSpeed(event.getOriginalSpeed() * (1.0f + bonus));
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (source instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)source;
            float pureStar = (float)CFFlags.PURE_NETHER_STAR.getItemsForFlag(entity).size() * ((Double)CFModConfig.COMMON.pureStarDamageFactor.get()).floatValue();
            event.setAmount(event.getAmount() + target.m_21233_() * pureStar);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Player player;
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof Player && (player = (Player)attacker).m_21215_() <= 2) {
            float voidEssence = (float)CFFlags.VOID_ESSENCE.getItemsForFlag((LivingEntity)player).size() * ((Double)CFModConfig.COMMON.voidEssenceExtraDamage.get()).floatValue();
            GeneralEventHandler.schedule(() -> target.m_6469_(CCDamageTypes.abyss((LivingEntity)player), voidEssence));
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)attacker;
            float deathEssence = (float)CFFlags.DEATH_ESSENCE.getItemsForFlag(entity).size() * ((Double)CFModConfig.COMMON.deathEssenceDamageHeal.get()).floatValue();
            entity.m_5634_(deathEssence * event.getAmount());
        }
    }
}

