/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.events;

import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.content.modifier.ModifierHolder;
import com.xiaoyue.celestial_forge.content.modifier.ModifierInstance;
import com.xiaoyue.celestial_forge.content.modifier.ModifierInstanceEntry;
import com.xiaoyue.celestial_forge.data.CFModConfig;
import com.xiaoyue.celestial_forge.register.CFItems;
import com.xiaoyue.celestial_forge.utils.ModifierUtils;
import com.xiaoyue.celestial_forge.utils.TypeTestUtils;
import dev.xkmc.l2library.util.math.MathHelper;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="celestial_forge", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierHandler {
    @SubscribeEvent
    public static void onItemAttribute(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        ModifierInstance mod = ModifierUtils.getModifier(stack);
        if (mod == null) {
            return;
        }
        ModifierType type = TypeTestUtils.getType(stack);
        EquipmentSlot slot = event.getSlotType();
        if (slot.m_254934_() && slot != LivingEntity.m_147233_((ItemStack)stack)) {
            return;
        }
        if (type != null && type.test(slot)) {
            for (int i = 0; i < mod.size(); ++i) {
                ModifierInstanceEntry entry = mod.get(i);
                String name = String.valueOf(slot) + "/" + String.valueOf(mod.holder().id()) + "/" + i;
                UUID id = MathHelper.getUUIDFromString((String)name);
                event.addModifier(entry.entry().attr(), entry.getAttributeModifier(id, name));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onMobExpDrop(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player == null) {
            return;
        }
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ModifierUtils.addExpToPlayer(player, event.getDroppedExperience());
    }

    @SubscribeEvent
    public static void modifierRecipe(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft().m_41777_();
        ItemStack right = event.getRight();
        ModifierInstance ins = ModifierUtils.getModifier(left);
        if (!right.m_150930_((Item)CFItems.MODIFIER_BOOK.get())) {
            return;
        }
        ModifierHolder book = ModifierUtils.fromBook(right);
        if (book == null) {
            if (ins == null) {
                return;
            }
            int minLv = (Integer)CFModConfig.COMMON.modifierToBookLevel.get();
            if (ins.level() < minLv) {
                return;
            }
            event.setMaterialCost(1);
            event.setCost(((Integer)CFModConfig.COMMON.modifierBookCraftCost.get()).intValue());
            event.setOutput(ModifierUtils.bookOf(ins.holder()));
        } else {
            if (ins != null || !TypeTestUtils.mightHaveModifiers(left)) {
                return;
            }
            if (book.type() != ModifierType.ALL && book.type() != TypeTestUtils.getType(left)) {
                return;
            }
            ModifierUtils.setModifier(left, ModifierInstance.of(book));
            event.setMaterialCost(1);
            event.setOutput(left);
            event.setCost(((Integer)CFModConfig.COMMON.modifierBookRecipeCost.get()).intValue());
        }
    }

    @SubscribeEvent
    public static void grind(GrindstoneEvent.OnPlaceItem event) {
        ItemStack stack = event.getTopItem();
        ModifierInstance ins = ModifierUtils.getModifier(stack);
        if (ins == null) {
            return;
        }
        int maxLv = (Integer)CFModConfig.COMMON.grindstoneRemovalPriorityLevel.get();
        if (!stack.m_41793_() || ins.level() <= maxLv) {
            ItemStack copy = stack.m_41777_();
            ModifierUtils.removeModifier(copy);
            event.setOutput(copy);
            event.setXp(3 + ins.level());
        }
    }
}

