/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.utils;

import com.xiaoyue.celestial_forge.data.CFModConfig;
import com.xiaoyue.celestial_forge.data.CFTagGen;
import com.xiaoyue.celestial_forge.events.CuriosHandler;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CurioUtils {
    private static boolean loaded() {
        return ModList.get().isLoaded("curios");
    }

    public static void addPlayerSlots(Player player, Consumer<ItemStack> action) {
        if (!CurioUtils.loaded()) {
            return;
        }
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        if (opt.isPresent()) {
            for (ICurioStacksHandler a : ((ICuriosItemHandler)opt.get()).getCurios().values()) {
                int n = a.getSlots();
                for (int i = 0; i < n; ++i) {
                    ItemStack stack = a.getStacks().getStackInSlot(i);
                    action.accept(stack);
                }
            }
        }
    }

    public static boolean isCurio(ItemStack stack, boolean isClient) {
        if (!CurioUtils.loaded()) {
            return false;
        }
        if (!((Boolean)CFModConfig.COMMON.enableCurioForging.get()).booleanValue()) {
            return false;
        }
        if (stack.m_204117_(CFTagGen.CURIO_MODIFIABLE)) {
            return true;
        }
        Map map = CuriosApi.getItemStackSlots((ItemStack)stack, (boolean)isClient);
        if (map.isEmpty()) {
            return false;
        }
        for (ISlotType e : map.values()) {
            if (!e.useNativeGui()) continue;
            return true;
        }
        return false;
    }

    public static void register() {
        if (CurioUtils.loaded()) {
            MinecraftForge.EVENT_BUS.register(CuriosHandler.class);
        }
    }
}

