/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.utils;

import com.mojang.datafixers.util.Pair;
import com.xiaoyue.celestial_forge.content.data.ModifierDataHolder;
import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.content.modifier.ModifierHolder;
import com.xiaoyue.celestial_forge.content.modifier.ModifierInstance;
import com.xiaoyue.celestial_forge.data.CFModConfig;
import com.xiaoyue.celestial_forge.register.CFItems;
import com.xiaoyue.celestial_forge.utils.CurioUtils;
import com.xiaoyue.celestial_forge.utils.TypeTestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModifierUtils {
    public static final String tagName = "CelestialForge_ItemModifier";
    public static final String levelName = "CelestialForge_ItemLevel";
    public static final String expName = "CelestialForge_ItemExp";
    public static final String bookTagName = "CelestialForge_BookModifier";

    @Nullable
    public static ModifierInstance rollModifier(ItemStack stack, RandomSource random) {
        ModifierType type = TypeTestUtils.getType(stack, false);
        if (type == null) {
            return null;
        }
        ModifierHolder ins = ModifierDataHolder.byType(type).roll(random);
        return ins == null ? null : ModifierInstance.of(ins);
    }

    public static void removeModifier(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(tagName);
            tag.m_128473_(levelName);
            tag.m_128473_(expName);
        }
    }

    public static void setModifier(ItemStack stack, ModifierInstance modifier) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(tagName, modifier.holder().id().toString());
        tag.m_128405_(levelName, modifier.level());
        tag.m_128405_(expName, modifier.exp());
    }

    @Nullable
    public static ModifierInstance getModifier(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        if (!TypeTestUtils.mightHaveModifiers(stack)) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        if (!tag.m_128441_(tagName)) {
            return null;
        }
        int level = tag.m_128451_(levelName);
        int exp = tag.m_128451_(expName);
        ModifierHolder ans = ModifierDataHolder.byId(new ResourceLocation(tag.m_128461_(tagName)));
        return ans == null ? null : new ModifierInstance(ans, level, exp);
    }

    @Nullable
    public static ModifierHolder fromBook(ItemStack right) {
        CompoundTag tag = right.m_41783_();
        return tag == null ? null : ModifierDataHolder.byId(new ResourceLocation(tag.m_128461_(bookTagName)));
    }

    public static ItemStack bookOf(ModifierHolder mod) {
        ItemStack stack = new ItemStack((ItemLike)CFItems.MODIFIER_BOOK.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(bookTagName, mod.id().toString());
        return stack;
    }

    public static int getMaxExp(int level) {
        double rate = (Double)CFModConfig.COMMON.modifierMaxLevelRate.get();
        int base = (Integer)CFModConfig.COMMON.modifierMaxLevelBase.get();
        return (int)(Math.pow(2.0, (double)level * rate) * (double)base);
    }

    public static void addExp(ItemStack stack, ModifierInstance modifier, int toAdd) {
        ModifierUtils.setModifier(stack, modifier.addExp(toAdd));
    }

    public static List<Pair<ItemStack, ModifierInstance>> getAllOnPlayer(Player player) {
        ArrayList<Pair<ItemStack, ModifierInstance>> list = new ArrayList<Pair<ItemStack, ModifierInstance>>();
        for (EquipmentSlot e : EquipmentSlot.values()) {
            ModifierInstance ins;
            ItemStack stack2 = player.m_6844_(e);
            if (stack2.m_41619_() || (ins = ModifierUtils.getModifier(stack2)) == null || !ins.canUpgrade()) continue;
            list.add((Pair<ItemStack, ModifierInstance>)Pair.of((Object)stack2, (Object)ins));
        }
        CurioUtils.addPlayerSlots(player, stack -> Optional.ofNullable(ModifierUtils.getModifier(stack)).filter(ModifierInstance::canUpgrade).ifPresent(ins -> list.add(Pair.of((Object)stack, (Object)ins))));
        return list;
    }

    public static void addExpToPlayer(Player player, int total) {
        List<Pair<ItemStack, ModifierInstance>> list = ModifierUtils.getAllOnPlayer(player);
        int n = list.size();
        if (n == 0) {
            return;
        }
        int base = total / n;
        int avail = total - base;
        RandomSource r = player.m_217043_();
        for (int i = 0; i < n; ++i) {
            int a = r.m_188503_(n);
            int b = r.m_188503_(n);
            Pair<ItemStack, ModifierInstance> t = list.get(a);
            list.set(a, list.get(b));
            list.set(b, t);
        }
        for (Pair<ItemStack, ModifierInstance> e : list) {
            int toAdd = base;
            if (avail > 0) {
                ++toAdd;
                --avail;
            }
            ModifierUtils.addExp((ItemStack)e.getFirst(), (ModifierInstance)e.getSecond(), toAdd);
        }
    }
}

