/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_forge.utils;

import com.xiaoyue.celestial_forge.content.data.ModifierType;
import com.xiaoyue.celestial_forge.data.CFModConfig;
import com.xiaoyue.celestial_forge.data.CFTagGen;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TypeTestUtils {
    private static final HashSet<Item> INVALID = new HashSet();
    public static final HashMap<Item, ModifierType> CACHE = new HashMap();

    public static void clearCache() {
        INVALID.clear();
        CACHE.clear();
    }

    public static boolean mightHaveModifiers(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41741_() == 1 && !stack.m_204117_(CFTagGen.MODIFIER_BLACK_LIST);
    }

    public static boolean isRangedWeapon(ItemStack stack) {
        if (!((Boolean)CFModConfig.COMMON.enableRangedForging.get()).booleanValue()) {
            return false;
        }
        return stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem || stack.m_204117_(CFTagGen.RANGED_MODIFIABLE);
    }

    public static boolean isTool(ItemStack stack) {
        if (!((Boolean)CFModConfig.COMMON.enableToolForging.get()).booleanValue()) {
            return false;
        }
        return stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof ShieldItem || stack.m_41720_() instanceof FishingRodItem || stack.m_204117_(CFTagGen.TOOL_MODIFIABLE);
    }

    public static boolean isArmor(ItemStack stack) {
        if (!((Boolean)CFModConfig.COMMON.enableArmorForging.get()).booleanValue()) {
            return false;
        }
        return stack.m_41720_() instanceof ArmorItem || stack.m_204117_(CFTagGen.ARMOR_MODIFIABLE);
    }

    public static boolean isWeapon(ItemStack stack) {
        if (!((Boolean)CFModConfig.COMMON.enableWeaponForging.get()).booleanValue()) {
            return false;
        }
        return stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof TridentItem || stack.m_204117_(CFTagGen.WEAPON_MODIFIABLE);
    }

    @Nullable
    public static ModifierType getType(ItemStack stack) {
        return TypeTestUtils.getType(stack, ServerLifecycleHooks.getCurrentServer() == null);
    }

    @Nullable
    public static ModifierType getType(ItemStack stack, boolean isClient) {
        if (!TypeTestUtils.mightHaveModifiers(stack)) {
            return null;
        }
        if (INVALID.contains(stack.m_41720_())) {
            return null;
        }
        ModifierType ans = CACHE.get(stack.m_41720_());
        if (ans != null) {
            return ans;
        }
        for (ModifierType e : ModifierType.values()) {
            if (!e.test(stack, isClient)) continue;
            CACHE.put(stack.m_41720_(), e);
            return e;
        }
        INVALID.add(stack.m_41720_());
        return null;
    }
}

