/*
 * Decompiled with CFR 0.152.
 */
package net.domixcze.pinit.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get("config", "pinit.json");
    public List<Integer> pinnedSlotIndices = new ArrayList<Integer>();
    public boolean totalCountMode = false;
    public boolean enableSlotPinning = true;
    public boolean enableRecipePinning = true;
    public PinShape selectedShape = PinShape.SQUARE_PIN;
    public int pinColor = 0x5555FF;
    public List<String> pinnedRecipeIds = new ArrayList<String>();
    public static ModConfig INSTANCE = new ModConfig();

    public static void loadConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new ModConfig();
                    ModConfig.saveConfig();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load config for PinIt: " + e.getMessage());
                INSTANCE = new ModConfig();
                ModConfig.saveConfig();
            }
        } else {
            ModConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config for PinIt: " + e.getMessage());
        }
    }

    public static enum PinShape {
        SQUARE_PIN(class_2960.method_60655((String)"pinit", (String)"textures/gui/pin_base.png"), class_2960.method_60655((String)"pinit", (String)"textures/gui/square_pin_overlay.png")),
        CIRCLE_PIN(class_2960.method_60655((String)"pinit", (String)"textures/gui/pin_base.png"), class_2960.method_60655((String)"pinit", (String)"textures/gui/circle_pin_overlay.png")),
        PAPER_CLIP(null, class_2960.method_60655((String)"pinit", (String)"textures/gui/paper_clip.png")),
        STAR(null, class_2960.method_60655((String)"pinit", (String)"textures/gui/star.png")),
        HEART(null, class_2960.method_60655((String)"pinit", (String)"textures/gui/heart.png"));

        public final class_2960 base;
        public final class_2960 overlay;

        private PinShape(class_2960 base, class_2960 overlay) {
            this.base = base;
            this.overlay = overlay;
        }
    }
}

