/*
 * Decompiled with CFR 0.152.
 */
package uk.regressia.mod.pplus.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ColdFrogDollBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public ColdFrogDollBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOL).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).ignitedByLava());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.pplus.cold_frog_doll.description_0"));
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getBlock() == this ? true : super.skipRendering(state, adjacentBlockState, side);
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)ColdFrogDollBlock.box((double)4.5, (double)1.0, (double)2.5, (double)11.5, (double)6.0, (double)13.5), (VoxelShape[])new VoxelShape[]{ColdFrogDollBlock.box((double)8.5, (double)6.0, (double)9.5, (double)11.5, (double)8.0, (double)12.5), ColdFrogDollBlock.box((double)4.5, (double)6.0, (double)9.5, (double)7.5, (double)8.0, (double)12.5), ColdFrogDollBlock.box((double)11.25, (double)0.0, (double)10.0, (double)13.25, (double)3.0, (double)13.0), ColdFrogDollBlock.box((double)11.25, (double)0.0, (double)2.0, (double)13.25, (double)3.0, (double)6.0), ColdFrogDollBlock.box((double)2.75, (double)0.0, (double)10.0, (double)4.75, (double)3.0, (double)13.0), ColdFrogDollBlock.box((double)2.75, (double)0.0, (double)2.0, (double)4.75, (double)3.0, (double)6.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)ColdFrogDollBlock.box((double)4.5, (double)1.0, (double)2.5, (double)11.5, (double)6.0, (double)13.5), (VoxelShape[])new VoxelShape[]{ColdFrogDollBlock.box((double)4.5, (double)6.0, (double)3.5, (double)7.5, (double)8.0, (double)6.5), ColdFrogDollBlock.box((double)8.5, (double)6.0, (double)3.5, (double)11.5, (double)8.0, (double)6.5), ColdFrogDollBlock.box((double)2.75, (double)0.0, (double)3.0, (double)4.75, (double)3.0, (double)6.0), ColdFrogDollBlock.box((double)2.75, (double)0.0, (double)10.0, (double)4.75, (double)3.0, (double)14.0), ColdFrogDollBlock.box((double)11.25, (double)0.0, (double)3.0, (double)13.25, (double)3.0, (double)6.0), ColdFrogDollBlock.box((double)11.25, (double)0.0, (double)10.0, (double)13.25, (double)3.0, (double)14.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)ColdFrogDollBlock.box((double)2.5, (double)1.0, (double)4.5, (double)13.5, (double)6.0, (double)11.5), (VoxelShape[])new VoxelShape[]{ColdFrogDollBlock.box((double)9.5, (double)6.0, (double)4.5, (double)12.5, (double)8.0, (double)7.5), ColdFrogDollBlock.box((double)9.5, (double)6.0, (double)8.5, (double)12.5, (double)8.0, (double)11.5), ColdFrogDollBlock.box((double)10.0, (double)0.0, (double)2.75, (double)13.0, (double)3.0, (double)4.75), ColdFrogDollBlock.box((double)2.0, (double)0.0, (double)2.75, (double)6.0, (double)3.0, (double)4.75), ColdFrogDollBlock.box((double)10.0, (double)0.0, (double)11.25, (double)13.0, (double)3.0, (double)13.25), ColdFrogDollBlock.box((double)2.0, (double)0.0, (double)11.25, (double)6.0, (double)3.0, (double)13.25)});
            case Direction.WEST -> Shapes.or((VoxelShape)ColdFrogDollBlock.box((double)2.5, (double)1.0, (double)4.5, (double)13.5, (double)6.0, (double)11.5), (VoxelShape[])new VoxelShape[]{ColdFrogDollBlock.box((double)3.5, (double)6.0, (double)8.5, (double)6.5, (double)8.0, (double)11.5), ColdFrogDollBlock.box((double)3.5, (double)6.0, (double)4.5, (double)6.5, (double)8.0, (double)7.5), ColdFrogDollBlock.box((double)3.0, (double)0.0, (double)11.25, (double)6.0, (double)3.0, (double)13.25), ColdFrogDollBlock.box((double)10.0, (double)0.0, (double)11.25, (double)14.0, (double)3.0, (double)13.25), ColdFrogDollBlock.box((double)3.0, (double)0.0, (double)2.75, (double)6.0, (double)3.0, (double)4.75), ColdFrogDollBlock.box((double)10.0, (double)0.0, (double)2.75, (double)14.0, (double)3.0, (double)4.75)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }
}

