/*
 * Decompiled with CFR 0.152.
 */
package uk.regressia.mod.pplus.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DogDollblueBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public DogDollblueBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOL).strength(0.8f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).ignitedByLava());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.pplus.dog_dollblue.description_0"));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)DogDollblueBlock.box((double)5.0, (double)7.0, (double)8.75, (double)11.0, (double)12.0, (double)13.75), (VoxelShape)DogDollblueBlock.box((double)6.5, (double)2.0, (double)2.0, (double)9.5, (double)7.5, (double)12.0));
            case Direction.NORTH -> Shapes.or((VoxelShape)DogDollblueBlock.box((double)5.0, (double)7.0, (double)2.25, (double)11.0, (double)12.0, (double)7.25), (VoxelShape)DogDollblueBlock.box((double)6.5, (double)2.0, (double)4.0, (double)9.5, (double)7.5, (double)14.0));
            case Direction.EAST -> Shapes.or((VoxelShape)DogDollblueBlock.box((double)8.75, (double)7.0, (double)5.0, (double)13.75, (double)12.0, (double)11.0), (VoxelShape)DogDollblueBlock.box((double)2.0, (double)2.0, (double)6.5, (double)12.0, (double)7.5, (double)9.5));
            case Direction.WEST -> Shapes.or((VoxelShape)DogDollblueBlock.box((double)2.25, (double)7.0, (double)5.0, (double)7.25, (double)12.0, (double)11.0), (VoxelShape)DogDollblueBlock.box((double)4.0, (double)2.0, (double)6.5, (double)14.0, (double)7.5, (double)9.5));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

