/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound;

import com.example.fear_of_sound.SoundSystemFacade;
import com.example.fear_of_sound.config.FearofSoundConfig;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="fear_of_sound", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    private static final ThreadLocal<Boolean> IS_HANDLING_SOUND = ThreadLocal.withInitial(() -> false);
    private static final double IDLE_THRESHOLD_SQ = 4.0E-4;
    private static final double CRAWLING_THRESHOLD_SQ = 0.0036;
    private static final double SNEAKING_SPEED_SQ = 0.0144;
    private static final double WALKING_SPEED_SQ = 0.07840000000000001;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlaySoundEvent(PlaySoundEvent event) {
        if (IS_HANDLING_SOUND.get().booleanValue()) {
            return;
        }
        try {
            IS_HANDLING_SOUND.set(true);
            if (event.getSound() == null || !FearofSoundConfig.SOUND_BASED_DETECTION_ENABLED_CACHE) {
                return;
            }
            ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
            LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
            if (clientWorld == null || clientPlayer == null) {
                return;
            }
            SoundInstance soundInstance = event.getSound();
            if (soundInstance instanceof AbstractSoundInstance) {
                AbstractSoundInstance soundInstance2 = (AbstractSoundInstance)soundInstance;
                ResourceLocation soundRL = soundInstance2.m_7904_();
                if (soundRL == null) {
                    return;
                }
                SoundEvent se = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundRL);
                if (se == null) {
                    return;
                }
                double x = soundInstance2.m_7772_();
                double y = soundInstance2.m_7780_();
                double z = soundInstance2.m_7778_();
                ResourceLocation dim = clientWorld.m_46472_().m_135782_();
                Optional<UUID> sourcePlayerUUID = Optional.empty();
                int calculatedRange = -1;
                double calculatedWeight = 1.0;
                if (FearofSoundConfig.PLAYER_STEP_SOUNDS_CACHE.contains(se) && clientPlayer.m_20182_().m_82531_(x, y, z) < 2.25) {
                    sourcePlayerUUID = Optional.of(clientPlayer.m_20148_());
                    Vec3 motion = clientPlayer.m_20184_();
                    double horizontalSpeedSq = motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_;
                    boolean isOnGround = clientPlayer.m_20096_();
                    boolean isSneaking = clientPlayer.m_6144_();
                    boolean isSprinting = clientPlayer.m_20142_();
                    PlayerAction currentAction = PlayerAction.IDLE;
                    if (isSneaking) {
                        if (horizontalSpeedSq > 4.0E-4 && horizontalSpeedSq <= 0.0036) {
                            currentAction = PlayerAction.CRAWLING;
                        } else if (horizontalSpeedSq > 0.0036 && horizontalSpeedSq <= 0.01584) {
                            currentAction = PlayerAction.SNEAKING;
                        }
                    } else if (isSprinting && !isOnGround) {
                        currentAction = PlayerAction.SPRINT_JUMPING;
                    } else if (isSprinting && horizontalSpeedSq > 0.07840000000000001) {
                        currentAction = PlayerAction.SPRINTING;
                    } else if (isOnGround && horizontalSpeedSq > 4.0E-4) {
                        currentAction = PlayerAction.WALKING;
                    }
                    switch (currentAction) {
                        case CRAWLING: {
                            calculatedRange = 3;
                            calculatedWeight = 1.0;
                            break;
                        }
                        case SNEAKING: {
                            calculatedRange = 5;
                            calculatedWeight = 1.0;
                            break;
                        }
                        case WALKING: {
                            calculatedRange = 10;
                            calculatedWeight = 1.0;
                            break;
                        }
                        case SPRINTING: {
                            calculatedRange = 16;
                            calculatedWeight = 1.0;
                            break;
                        }
                        case SPRINT_JUMPING: {
                            calculatedRange = 20;
                            calculatedWeight = 1.0;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                SoundSystemFacade.broadcastClientSound(soundRL, x, y, z, dim, sourcePlayerUUID, calculatedRange, calculatedWeight);
            }
        }
        finally {
            IS_HANDLING_SOUND.remove();
        }
    }

    private static enum PlayerAction {
        IDLE,
        CRAWLING,
        SNEAKING,
        WALKING,
        SPRINTING,
        SPRINT_JUMPING;

    }
}

