/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound;

import com.example.fear_of_sound.FearofSoundMod;
import com.example.fear_of_sound.SoundTracker;
import com.example.fear_of_sound.ai.FearGoal;
import com.example.fear_of_sound.ai.PlayDeadGoal;
import com.example.fear_of_sound.config.AdvancedFearOverrideRegistry;
import com.example.fear_of_sound.config.FearofSoundConfig;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="fear_of_sound", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoundFearEvents {
    private static int attachScanTicker = 0;

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (!FearofSoundMod.isSoundAttractLoaded && event.phase == TickEvent.Phase.END && !event.level.m_5776_() && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SoundTracker.pruneIrrelevantSounds((Level)serverLevel);
        }
        if (event.phase == TickEvent.Phase.END && !event.level.m_5776_() && (level = event.level) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (++attachScanTicker % 40 == 0) {
                List mobs = server.m_45976_(PathfinderMob.class, server.m_6857_().m_61946_().m_83215_());
                int processed = 0;
                for (PathfinderMob pMob : mobs) {
                    boolean goalExists;
                    String entityIdStr;
                    boolean needFear;
                    ResourceLocation entityId;
                    if (processed++ > 128) break;
                    boolean bypassed = false;
                    for (FearofSoundConfig.BypassDefinition bypass : FearofSoundConfig.BYPASSED_ENTITIES_CACHE) {
                        if (bypass.customName() != null && pMob.m_8077_() && pMob.m_7770_().getString().equals(bypass.customName())) {
                            bypassed = true;
                            break;
                        }
                        if (bypass.nbt() == null) continue;
                        CompoundTag mobNbt = new CompoundTag();
                        pMob.m_20240_(mobNbt);
                        if (!NbtUtils.m_129235_((Tag)bypass.nbt(), (Tag)mobNbt, (boolean)true)) continue;
                        bypassed = true;
                        break;
                    }
                    if (bypassed || (entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)pMob.m_6095_())) == null || !(needFear = FearofSoundConfig.AFFECTED_ENTITIES_CACHE.contains(entityIdStr = entityId.toString()) || AdvancedFearOverrideRegistry.hasAnyRuleFor(pMob.m_6095_())) || (goalExists = pMob.f_21345_.m_148105_().stream().anyMatch(g -> g.m_26015_() instanceof FearGoal))) continue;
                    double moveSpeed = (Double)FearofSoundConfig.COMMON.mobMoveSpeed.get();
                    pMob.f_21345_.m_25352_(2, (Goal)new FearGoal(pMob, moveSpeed));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            boolean goalExists;
            PathfinderMob pMob = (PathfinderMob)entity;
            for (FearofSoundConfig.BypassDefinition bypass : FearofSoundConfig.BYPASSED_ENTITIES_CACHE) {
                if (bypass.customName() != null && pMob.m_8077_() && pMob.m_7770_().getString().equals(bypass.customName())) {
                    return;
                }
                if (bypass.nbt() == null) continue;
                CompoundTag mobNbt = new CompoundTag();
                pMob.m_20240_(mobNbt);
                if (!NbtUtils.m_129235_((Tag)bypass.nbt(), (Tag)mobNbt, (boolean)true)) continue;
                return;
            }
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)pMob.m_6095_());
            if (entityId == null) {
                return;
            }
            String entityIdStr = entityId.toString();
            if (FearofSoundConfig.PLAY_DEAD_ENTITIES_CACHE.contains(entityIdStr)) {
                boolean goalExists2 = pMob.f_21345_.m_148105_().stream().anyMatch(g -> g.m_26015_() instanceof PlayDeadGoal);
                if (!goalExists2) {
                    pMob.f_21345_.m_25352_(0, (Goal)new PlayDeadGoal(pMob));
                }
            } else if ((FearofSoundConfig.AFFECTED_ENTITIES_CACHE.contains(entityIdStr) || AdvancedFearOverrideRegistry.hasAnyRuleFor(pMob.m_6095_())) && !(goalExists = pMob.f_21345_.m_148105_().stream().anyMatch(g -> g.m_26015_() instanceof FearGoal))) {
                double moveSpeed = (Double)FearofSoundConfig.COMMON.mobMoveSpeed.get();
                pMob.f_21345_.m_25352_(0, (Goal)new FearGoal(pMob, moveSpeed));
            }
        }
    }
}

