/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound;

import com.example.fear_of_sound.SoundTracker;
import com.example.fear_of_sound.config.FearofSoundConfig;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SoundMessage {
    private final ResourceLocation soundId;
    private final double x;
    private final double y;
    private final double z;
    private final ResourceLocation dimension;
    private final Optional<UUID> sourcePlayerUUID;
    private final int range;
    private final double weight;

    public SoundMessage(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, -1, 1.0);
    }

    public SoundMessage(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID, int range) {
        this(soundId, x, y, z, dimension, sourcePlayerUUID, range, 1.0);
    }

    public SoundMessage(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID, int range, double weight) {
        this.soundId = soundId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
        this.sourcePlayerUUID = sourcePlayerUUID;
        this.range = range;
        this.weight = weight;
    }

    public static void encode(SoundMessage msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.soundId);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.m_130085_(msg.dimension);
        buf.m_236835_(msg.sourcePlayerUUID, FriendlyByteBuf::m_130077_);
        buf.writeInt(msg.range);
        buf.writeDouble(msg.weight);
    }

    public static SoundMessage decode(FriendlyByteBuf buf) {
        ResourceLocation soundId = buf.m_130281_();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        ResourceLocation dimension = buf.m_130281_();
        Optional sourcePlayerUUID = buf.m_236860_(FriendlyByteBuf::m_130259_);
        int range = buf.readInt();
        double weight = buf.readDouble();
        return new SoundMessage(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight);
    }

    public static void handle(SoundMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            MinecraftServer server;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerLevel serverLevel = null;
            if (sender != null) {
                serverLevel = sender.f_8924_.m_129880_(sender.m_9236_().m_46472_());
            } else if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer() && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
                ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)msg.dimension);
                serverLevel = server.m_129880_(levelKey);
            }
            if (serverLevel == null || !serverLevel.m_46472_().m_135782_().equals((Object)msg.dimension)) {
                return;
            }
            BlockPos pos = BlockPos.m_274561_((double)msg.x, (double)msg.y, (double)msg.z);
            String dimString = msg.dimension.toString();
            int lifetime = (Integer)FearofSoundConfig.COMMON.soundLifetimeTicks.get();
            SoundEvent snd = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(msg.soundId);
            if (snd == null) {
                return;
            }
            if (msg.range >= 0) {
                SoundTracker.addSound(snd, pos, dimString, msg.range, msg.weight, lifetime);
            } else {
                FearofSoundConfig.SoundConfig config = FearofSoundConfig.SOUND_CONFIGS_CACHE.get(snd);
                if (config != null) {
                    SoundTracker.addSound(snd, pos, dimString, config.range, config.weight, lifetime);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

