/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound;

import com.example.fear_of_sound.FearofSoundMod;
import com.example.fear_of_sound.SoundMessage;
import com.example.fear_of_sound.SoundNetwork;
import com.example.fear_of_sound.SoundTracker;
import com.example.fear_of_sound.config.AdvancedFearOverrideRegistry;
import com.example.fear_of_sound.integration.SoundAttractIntegration;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundSystemFacade {
    public static void broadcastClientSound(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID, int range, double weight) {
        if (FearofSoundMod.isSoundAttractLoaded) {
            SoundAttractIntegration.sendSound(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight);
        } else {
            SoundMessage msg = new SoundMessage(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight);
            SoundNetwork.INSTANCE.sendToServer((Object)msg);
        }
    }

    public static void broadcastServerSound(SoundEvent se, double x, double y, double z, Level level) {
        if (FearofSoundMod.isSoundAttractLoaded) {
            com.example.soundattract.SoundTracker.addSound((SoundEvent)se, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z), (String)level.m_46472_().m_135782_().toString());
        } else {
            SoundTracker.addSound(se, BlockPos.m_274561_((double)x, (double)y, (double)z), level.m_46472_().m_135782_().toString());
        }
    }

    public static SoundTracker.SoundRecord findNearestSoundFor(Mob mob) {
        ResourceLocation sid;
        if (FearofSoundMod.isSoundAttractLoaded) {
            return SoundAttractIntegration.findNearestSound(mob);
        }
        SoundTracker.SoundRecord rec = SoundTracker.findNearestSound(mob.m_9236_(), mob.m_20183_());
        if (rec == null) {
            return null;
        }
        ResourceLocation resourceLocation = sid = rec.sound != null ? ForgeRegistries.SOUND_EVENTS.getKey((Object)rec.sound) : null;
        if (!AdvancedFearOverrideRegistry.shouldFear(mob, sid)) {
            return null;
        }
        return rec;
    }
}

