/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound;

import com.example.fear_of_sound.FearofSoundMod;
import com.example.fear_of_sound.config.FearofSoundConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundTracker {
    private static int CURRENT_TICK = 0;
    private static final List<SoundRecord> RECENT_SOUNDS = new ArrayList<SoundRecord>();
    private static final Map<CellKey, List<SoundRecord>> SPATIAL_INDEX = new HashMap<CellKey, List<SoundRecord>>();
    private static int MAX_RANGE_SEEN = 0;
    private static final LinkedHashMap<RaycastCacheKey, RaycastCacheValue> RAYCAST_CACHE = new LinkedHashMap(128, 0.75f, true);

    public static synchronized void addSound(SoundEvent se, BlockPos pos, String dimensionKey) {
        FearofSoundConfig.SoundConfig config = FearofSoundConfig.SOUND_CONFIGS_CACHE.get(se);
        if (config == null) {
            return;
        }
        int lifetime = (Integer)FearofSoundConfig.COMMON.soundLifetimeTicks.get();
        SoundTracker.addSound(se, pos, dimensionKey, config.range, config.weight, lifetime);
    }

    public static synchronized void addSound(SoundEvent se, BlockPos pos, String dimensionKey, double range, double weight, int lifetime) {
        String soundId = se != null ? String.valueOf(ForgeRegistries.SOUND_EVENTS.getKey((Object)se)) : "fear_of_sound:voicechat";
        List<SoundRecord> candidates = SoundTracker.getCandidatesAround(pos, dimensionKey, 1);
        for (SoundRecord r : candidates) {
            String rSoundId;
            ResourceLocation rId = r.sound != null ? ForgeRegistries.SOUND_EVENTS.getKey((Object)r.sound) : null;
            String string = rSoundId = rId != null ? rId.toString() : "fear_of_sound:voicechat";
            if (!r.dimensionKey.equals(dimensionKey) || !rSoundId.equals(soundId)) continue;
            int mergeRadius = FearofSoundConfig.MERGE_RADIUS_BLOCKS_CACHE;
            int mergeRadiusSqr = mergeRadius * mergeRadius;
            if (!(r.pos.m_123331_((Vec3i)pos) <= (double)mergeRadiusSqr)) continue;
            r.ticksRemaining = Math.max(r.ticksRemaining, lifetime);
            return;
        }
        SoundRecord rec = new SoundRecord(se, pos, lifetime, dimensionKey, range, weight);
        RECENT_SOUNDS.add(rec);
        SoundTracker.indexAdd(rec);
        MAX_RANGE_SEEN = Math.max(MAX_RANGE_SEEN, (int)Math.ceil(range));
        if (RECENT_SOUNDS.size() > FearofSoundConfig.MAX_SOUNDS_TRACKED_CACHE) {
            SoundRecord toRemove = null;
            double best = Double.MAX_VALUE;
            for (SoundRecord r : RECENT_SOUNDS) {
                if (!(r.weight < best)) continue;
                best = r.weight;
                toRemove = r;
            }
            if (toRemove != null) {
                RECENT_SOUNDS.remove(toRemove);
                SoundTracker.indexRemove(toRemove);
            }
        }
    }

    public static synchronized void tick() {
        ++CURRENT_TICK;
        Iterator<SoundRecord> iter = RECENT_SOUNDS.iterator();
        while (iter.hasNext()) {
            SoundRecord r = iter.next();
            --r.ticksRemaining;
            if (r.ticksRemaining > 0) continue;
            iter.remove();
            SoundTracker.indexRemove(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] applyBlockMuffling(Level level, BlockPos src, BlockPos dst, double origRange, double origWeight, String soundId) {
        String dimKey = level.m_46472_().m_135782_().toString();
        RaycastCacheKey key = new RaycastCacheKey(dst, src, soundId, dimKey);
        LinkedHashMap<RaycastCacheKey, RaycastCacheValue> linkedHashMap = RAYCAST_CACHE;
        synchronized (linkedHashMap) {
            RaycastCacheValue cached = RAYCAST_CACHE.get(key);
            if (cached != null && CURRENT_TICK - cached.tick <= FearofSoundConfig.RAYCAST_CACHE_TTL_TICKS_CACHE) {
                return cached.result;
            }
        }
        double range = origRange;
        double weight = origWeight;
        int x0 = src.m_123341_();
        int y0 = src.m_123342_();
        int z0 = src.m_123343_();
        int x1 = dst.m_123341_();
        int y1 = dst.m_123342_();
        int z1 = dst.m_123343_();
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int dz = Math.abs(z1 - z0);
        int sx = Integer.compare(x1, x0);
        int sy = Integer.compare(y1, y0);
        int sz = Integer.compare(z1, z0);
        int n = 1 + dx + dy + dz;
        int x = x0;
        int y = y0;
        int z = z0;
        int err1 = dx - dy;
        int err2 = dx - dz;
        for (int i = 0; i < n && range > 0.0 && weight > 0.0; ++i) {
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (!state.m_60795_()) {
                if (SoundTracker.isCustomWool(state, block)) {
                    range -= (double)FearofSoundConfig.WOOL_BLOCK_RANGE_REDUCTION_CACHE;
                    weight -= FearofSoundConfig.WOOL_BLOCK_WEIGHT_REDUCTION_CACHE;
                } else if (SoundTracker.isCustomThin(state, block)) {
                    range -= (double)FearofSoundConfig.THIN_BLOCK_RANGE_REDUCTION_CACHE;
                    weight -= FearofSoundConfig.THIN_BLOCK_WEIGHT_REDUCTION_CACHE;
                } else if (SoundTracker.isCustomNonSolid(state, block)) {
                    range -= (double)FearofSoundConfig.NON_SOLID_BLOCK_RANGE_REDUCTION_CACHE;
                    weight -= FearofSoundConfig.NON_SOLID_BLOCK_WEIGHT_REDUCTION_CACHE;
                } else if (SoundTracker.isCustomSolid(state, block)) {
                    range -= (double)FearofSoundConfig.SOLID_BLOCK_RANGE_REDUCTION_CACHE;
                    weight -= FearofSoundConfig.SOLID_BLOCK_WEIGHT_REDUCTION_CACHE;
                }
            }
            if (x == x1 && y == y1 && z == z1) break;
            int e2 = 2 * err1;
            int e3 = 2 * err2;
            if (e2 > -dy) {
                err1 -= dy;
                x += sx;
            }
            if (e2 < dx) {
                err1 += dx;
                y += sy;
            }
            if (e3 > -dz) {
                err2 -= dz;
                x += sx;
            }
            if (e3 >= dx) continue;
            err2 += dx;
            z += sz;
        }
        if (range < 0.0) {
            range = 0.0;
        }
        if (weight < 0.0) {
            weight = 0.0;
        }
        double[] result = new double[]{range, weight};
        LinkedHashMap<RaycastCacheKey, RaycastCacheValue> linkedHashMap2 = RAYCAST_CACHE;
        synchronized (linkedHashMap2) {
            Iterator<Map.Entry<RaycastCacheKey, RaycastCacheValue>> it;
            RAYCAST_CACHE.put(key, new RaycastCacheValue(result, CURRENT_TICK));
            while (RAYCAST_CACHE.size() > FearofSoundConfig.RAYCAST_CACHE_MAX_ENTRIES_CACHE && (it = RAYCAST_CACHE.entrySet().iterator()).hasNext()) {
                it.next();
                it.remove();
            }
        }
        return result;
    }

    private static boolean isBlockInConfigList(BlockState state, Block block, List<String> configList) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id != null && configList.contains(id.toString())) {
            return true;
        }
        for (String entry : configList) {
            String tagName;
            TagKey tagKey;
            if (!entry.startsWith("#") || !state.m_204336_(tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(tagName = entry.substring(1))))) continue;
            return true;
        }
        return false;
    }

    private static boolean isCustomWool(BlockState state, Block block) {
        return SoundTracker.isBlockInConfigList(state, block, FearofSoundConfig.CUSTOM_WOOL_BLOCKS_CACHE) || state.m_204336_(BlockTags.f_13089_);
    }

    private static boolean isCustomSolid(BlockState state, Block block) {
        return SoundTracker.isBlockInConfigList(state, block, FearofSoundConfig.CUSTOM_SOLID_BLOCKS_CACHE) || state.m_280296_();
    }

    private static boolean isCustomNonSolid(BlockState state, Block block) {
        return SoundTracker.isBlockInConfigList(state, block, FearofSoundConfig.CUSTOM_NON_SOLID_BLOCKS_CACHE) || !state.m_280296_();
    }

    private static boolean isCustomThin(BlockState state, Block block) {
        if (SoundTracker.isBlockInConfigList(state, block, FearofSoundConfig.CUSTOM_THIN_BLOCKS_CACHE)) {
            return true;
        }
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id == null) {
            return false;
        }
        String path = id.m_135815_();
        return path.contains("pane") || path.contains("iron_bars") || path.contains("painting") || path.contains("fence") || path.contains("trapdoor") || path.contains("door") || path.contains("ladder") || path.contains("scaffolding") || path.contains("rail");
    }

    private static CellKey cellKey(BlockPos pos, String dimensionKey) {
        int gs = Math.max(1, FearofSoundConfig.SPATIAL_GRID_SIZE_CACHE);
        int cx = Math.floorDiv(pos.m_123341_(), gs);
        int cy = Math.floorDiv(pos.m_123342_(), gs);
        int cz = Math.floorDiv(pos.m_123343_(), gs);
        return new CellKey(dimensionKey, cx, cy, cz);
    }

    private static synchronized void indexAdd(SoundRecord r) {
        CellKey key = SoundTracker.cellKey(r.pos, r.dimensionKey);
        SPATIAL_INDEX.computeIfAbsent(key, k -> new ArrayList()).add(r);
    }

    private static synchronized void indexRemove(SoundRecord r) {
        CellKey key = SoundTracker.cellKey(r.pos, r.dimensionKey);
        List<SoundRecord> list = SPATIAL_INDEX.get(key);
        if (list != null) {
            list.remove(r);
            if (list.isEmpty()) {
                SPATIAL_INDEX.remove(key);
            }
        }
    }

    private static List<SoundRecord> getCandidatesAround(BlockPos pos, String dimensionKey, int radiusCells) {
        ArrayList<SoundRecord> out = new ArrayList<SoundRecord>();
        int gs = Math.max(1, FearofSoundConfig.SPATIAL_GRID_SIZE_CACHE);
        int cx = Math.floorDiv(pos.m_123341_(), gs);
        int cy = Math.floorDiv(pos.m_123342_(), gs);
        int cz = Math.floorDiv(pos.m_123343_(), gs);
        for (int dx = -radiusCells; dx <= radiusCells; ++dx) {
            for (int dy = -radiusCells; dy <= radiusCells; ++dy) {
                for (int dz = -radiusCells; dz <= radiusCells; ++dz) {
                    List<SoundRecord> list = SPATIAL_INDEX.get(new CellKey(dimensionKey, cx + dx, cy + dy, cz + dz));
                    if (list == null) continue;
                    out.addAll(list);
                }
            }
        }
        return out;
    }

    public static void pruneIrrelevantSounds(Level level) {
        if (RECENT_SOUNDS.isEmpty()) {
            return;
        }
        List mobs = level.m_45976_(Mob.class, level.m_6857_().m_61946_().m_83215_());
        Iterator<SoundRecord> iter = RECENT_SOUNDS.iterator();
        while (iter.hasNext()) {
            SoundRecord sound = iter.next();
            if (sound.ticksRemaining > 5) continue;
            boolean inRange = false;
            for (Mob mob : mobs) {
                if (!mob.m_6084_()) continue;
                BlockPos mobPos = mob.m_20183_();
                ResourceLocation soundLoc = sound.sound != null ? ForgeRegistries.SOUND_EVENTS.getKey((Object)sound.sound) : null;
                String soundId = soundLoc != null ? soundLoc.toString() : "fear_of_sound:voicechat";
                double[] muffled = SoundTracker.applyBlockMuffling(level, sound.pos, mobPos, sound.range, sound.weight, soundId);
                double range = muffled[0];
                double distSqr = mobPos.m_123331_((Vec3i)sound.pos);
                if (!(distSqr <= range * range)) continue;
                inRange = true;
                break;
            }
            if (inRange) continue;
            iter.remove();
            SoundTracker.indexRemove(sound);
        }
    }

    public static synchronized SoundRecord findNearestSound(Level level, BlockPos mobPos) {
        String dimensionKey = level.m_46472_().m_135782_().toString();
        SoundRecord bestSound = null;
        double closestDistSqr = Double.MAX_VALUE;
        double highestWeight = -1.7976931348623157E308;
        int gs = Math.max(1, FearofSoundConfig.SPATIAL_GRID_SIZE_CACHE);
        int radiusCells = Math.max(1, Math.min(8, (MAX_RANGE_SEEN + gs - 1) / gs));
        List<SoundRecord> candidates = SoundTracker.getCandidatesAround(mobPos, dimensionKey, radiusCells);
        if (candidates.isEmpty()) {
            candidates = RECENT_SOUNDS;
        }
        for (SoundRecord r : candidates) {
            if (!r.dimensionKey.equals(dimensionKey)) continue;
            ResourceLocation soundLoc = r.sound != null ? ForgeRegistries.SOUND_EVENTS.getKey((Object)r.sound) : null;
            String soundId = soundLoc != null ? soundLoc.toString() : "fear_of_sound:voicechat";
            double[] muffled = SoundTracker.applyBlockMuffling(level, r.pos, mobPos, r.range, r.weight, soundId);
            double muffledRange = muffled[0];
            double muffledWeight = muffled[1];
            double rangeSqr = muffledRange * muffledRange;
            double distSqr = mobPos.m_123331_((Vec3i)r.pos);
            if (!(distSqr <= rangeSqr) || !(muffledWeight > highestWeight) && (!(Math.abs(muffledWeight - highestWeight) < 0.001) || !(distSqr < closestDistSqr))) continue;
            highestWeight = muffledWeight;
            closestDistSqr = distSqr;
            bestSound = r;
        }
        if (bestSound != null) {
            FearofSoundMod.LOGGER.trace("[SoundTracker] Found best sound for mob at {}: {}", (Object)mobPos, bestSound);
        }
        return bestSound;
    }

    public static class SoundRecord {
        public final SoundEvent sound;
        public final BlockPos pos;
        public int ticksRemaining;
        public final String dimensionKey;
        public final double range;
        public final double weight;

        public SoundRecord(SoundEvent sound, BlockPos pos, int lifetime, String dimensionKey, double range, double weight) {
            this.sound = sound;
            this.pos = pos;
            this.ticksRemaining = lifetime;
            this.dimensionKey = dimensionKey;
            this.range = range;
            this.weight = weight;
        }
    }

    private static class RaycastCacheKey {
        public final BlockPos mobPos;
        public final BlockPos soundPos;
        public final String soundId;
        public final String dimensionKey;

        public RaycastCacheKey(BlockPos mobPos, BlockPos soundPos, String soundId, String dimensionKey) {
            this.mobPos = mobPos;
            this.soundPos = soundPos;
            this.soundId = soundId;
            this.dimensionKey = dimensionKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RaycastCacheKey)) {
                return false;
            }
            RaycastCacheKey other = (RaycastCacheKey)o;
            return this.mobPos.equals((Object)other.mobPos) && this.soundPos.equals((Object)other.soundPos) && this.soundId.equals(other.soundId) && this.dimensionKey.equals(other.dimensionKey);
        }

        public int hashCode() {
            return this.mobPos.hashCode() ^ this.soundPos.hashCode() ^ this.soundId.hashCode() ^ this.dimensionKey.hashCode();
        }
    }

    private static class RaycastCacheValue {
        public final double[] result;
        public final int tick;

        public RaycastCacheValue(double[] result, int tick) {
            this.result = result;
            this.tick = tick;
        }
    }

    private static class CellKey {
        public final String dimension;
        public final int cx;
        public final int cy;
        public final int cz;

        public CellKey(String dimension, int cx, int cy, int cz) {
            this.dimension = dimension;
            this.cx = cx;
            this.cy = cy;
            this.cz = cz;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CellKey)) {
                return false;
            }
            CellKey other = (CellKey)o;
            return this.cx == other.cx && this.cy == other.cy && this.cz == other.cz && this.dimension.equals(other.dimension);
        }

        public int hashCode() {
            return this.dimension.hashCode() * 31 * 31 * 31 + this.cx * 73856093 ^ this.cy * 19349663 ^ this.cz * 83492791;
        }
    }
}

