/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound.ai;

import com.example.fear_of_sound.SoundSystemFacade;
import com.example.fear_of_sound.SoundTracker;
import com.example.fear_of_sound.ai.FearSignals;
import com.example.fear_of_sound.config.FearofSoundConfig;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class FearGoal
extends Goal {
    protected final PathfinderMob mob;
    private final double moveSpeed;
    private static final int HORIZONTAL_FLEE_RANGE = 20;
    private static final int VERTICAL_FLEE_RANGE = 8;
    private static final int MIN_PANIC_TICKS = 20;
    private static final int MAX_PANIC_TICKS = 40;
    private static final double[] FALLBACK_ANGLES = new double[]{0.0, 0.7853981633974483, -0.7853981633974483, 1.5707963267948966, -1.5707963267948966, 2.356194490192345, -2.356194490192345, Math.PI};
    private FleeState state = FleeState.NOT_FLEEING;
    @Nullable
    private BlockPos targetSoundPos;
    private double safeDistSq;
    private int stateTicks;
    private int fleeingTicks;
    private int nearestCheckCooldown = 0;
    private int fleeSearchCooldown = 0;

    public FearGoal(PathfinderMob mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() != null || this.mob.m_21188_() != null) {
            return false;
        }
        FearSignals.Trigger instant = FearSignals.poll(this.mob, this.mob.m_9236_().m_46467_());
        if (instant != null) {
            this.targetSoundPos = instant.pos;
            double safeDistance = this.calculateSafeDistance(instant.range);
            this.safeDistSq = safeDistance * safeDistance;
            return true;
        }
        if (this.nearestCheckCooldown > 0) {
            --this.nearestCheckCooldown;
            return false;
        }
        this.nearestCheckCooldown = (Integer)FearofSoundConfig.COMMON.scanCooldownTicks.get();
        SoundTracker.SoundRecord record = this.findNearestSound();
        if (record == null) {
            return false;
        }
        double safeDistance = this.calculateSafeDistance(record.range);
        if (this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)record.pos)) >= safeDistance * safeDistance) {
            return false;
        }
        this.targetSoundPos = record.pos;
        this.safeDistSq = safeDistance * safeDistance;
        return true;
    }

    public boolean m_8045_() {
        return this.targetSoundPos != null && this.mob.m_5448_() == null && this.mob.m_21188_() == null;
    }

    public void m_8056_() {
        int duration;
        this.mob.m_21573_().m_26573_();
        int min = FearofSoundConfig.PANIC_MIN_TICKS_CACHE;
        int max = FearofSoundConfig.PANIC_MAX_TICKS_CACHE;
        int n = duration = max > min ? min + this.mob.m_217043_().m_188503_(max - min) : min;
        if (duration <= 0) {
            this.state = FleeState.FLEEING;
            this.findAndSetPath();
        } else {
            this.state = FleeState.PANICKING;
            this.stateTicks = duration;
        }
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        this.targetSoundPos = null;
        this.state = FleeState.NOT_FLEEING;
    }

    public void m_8037_() {
        if (this.targetSoundPos == null) {
            return;
        }
        switch (this.state) {
            case PANICKING: {
                this.handlePanicking();
                break;
            }
            case FLEEING: {
                this.handleFleeing();
                break;
            }
            case PAUSING: {
                this.handlePausing();
            }
        }
    }

    private void handlePanicking() {
        --this.stateTicks;
        Vec3 directionAway = this.mob.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)this.targetSoundPos)).m_82541_();
        this.mob.m_21563_().m_24946_(this.mob.m_20185_() + directionAway.f_82479_, this.mob.m_20188_(), this.mob.m_20189_() + directionAway.f_82481_);
        if (this.stateTicks <= 0) {
            this.state = FleeState.FLEEING;
            this.findAndSetPath();
        }
    }

    private void handleFleeing() {
        --this.fleeingTicks;
        PathNavigation nav = this.mob.m_21573_();
        if (nav.m_26571_() || nav.m_26577_() || this.fleeingTicks <= 0) {
            if (this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetSoundPos)) >= this.safeDistSq) {
                this.targetSoundPos = null;
                return;
            }
            if (this.fleeSearchCooldown > 0) {
                --this.fleeSearchCooldown;
                return;
            }
            this.findAndSetPath();
            this.fleeSearchCooldown = Math.max(5, (Integer)FearofSoundConfig.COMMON.scanCooldownTicks.get() / 2);
        }
    }

    private void handlePausing() {
        --this.stateTicks;
        Vec3 directionAway = this.mob.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)this.targetSoundPos)).m_82541_();
        this.mob.m_21563_().m_24946_(this.mob.m_20185_() + directionAway.f_82479_, this.mob.m_20188_(), this.mob.m_20189_() + directionAway.f_82481_);
        if (this.nearestCheckCooldown > 0) {
            --this.nearestCheckCooldown;
        } else {
            this.updateSoundSource();
            this.nearestCheckCooldown = (Integer)FearofSoundConfig.COMMON.scanCooldownTicks.get();
        }
        if (this.stateTicks <= 0) {
            if (this.fleeSearchCooldown > 0) {
                --this.fleeSearchCooldown;
                this.stateTicks = Math.max(this.stateTicks, 2);
            } else {
                this.state = FleeState.FLEEING;
                this.findAndSetPath();
                this.fleeSearchCooldown = Math.max(5, (Integer)FearofSoundConfig.COMMON.scanCooldownTicks.get() / 2);
            }
        }
    }

    private void findAndSetPath() {
        if (this.targetSoundPos == null) {
            return;
        }
        Vec3 fleePos = this.findFleePosition(this.targetSoundPos);
        if (fleePos != null) {
            if (this.mob.m_21573_().m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, this.moveSpeed * 1.33)) {
                this.fleeingTicks = 60 + this.mob.m_217043_().m_188503_(40);
            }
        } else {
            this.fleeSearchCooldown = Math.max(5, (Integer)FearofSoundConfig.COMMON.scanCooldownTicks.get() / 2);
        }
    }

    @Nullable
    private Vec3 findFleePosition(BlockPos soundBlockPos) {
        Vec3 soundCenter = Vec3.m_82512_((Vec3i)soundBlockPos);
        PathNavigation nav = this.mob.m_21573_();
        Vec3 directionAway = this.mob.m_20182_().m_82546_(soundCenter).m_82541_();
        Vec3 primaryCandidate = null;
        primaryCandidate = nav instanceof FlyingPathNavigation ? AirRandomPos.m_148387_((PathfinderMob)this.mob, (int)20, (int)8, (int)0, (Vec3)directionAway, (double)Math.PI) : (nav instanceof WaterBoundPathNavigation ? AirAndWaterRandomPos.m_148357_((PathfinderMob)this.mob, (int)20, (int)8, (int)-2, (double)directionAway.f_82479_, (double)directionAway.f_82481_, (double)1.5707963267948966) : LandRandomPos.m_148521_((PathfinderMob)this.mob, (int)20, (int)8, (Vec3)soundCenter));
        if (primaryCandidate != null && this.isPositionFurther(primaryCandidate, soundCenter)) {
            return primaryCandidate;
        }
        int tries = 0;
        for (double angle : FALLBACK_ANGLES) {
            Vec3 rotatedDir = directionAway.m_82524_((float)angle);
            Vec3 potentialTargetPos = this.mob.m_20182_().m_82549_(rotatedDir.m_82490_(10.0 + (double)this.mob.m_217043_().m_188503_(10)));
            Path path = nav.m_7864_(BlockPos.m_274446_((Position)potentialTargetPos), 1);
            if (path != null && path.m_77403_()) {
                return path.m_77406_().m_252807_();
            }
            if (++tries >= 3) break;
        }
        return null;
    }

    private boolean isPositionFurther(Vec3 candidatePos, Vec3 soundCenter) {
        return candidatePos.m_82557_(soundCenter) > this.mob.m_20182_().m_82557_(soundCenter);
    }

    private double calculateSafeDistance(double currentSoundRange) {
        double arrivalDistanceBuffer = (Double)FearofSoundConfig.COMMON.arrivalDistance.get();
        double randomOffset = this.mob.m_217043_().m_188500_() * 0.5 * arrivalDistanceBuffer;
        return Mth.m_14008_((double)(currentSoundRange + arrivalDistanceBuffer + randomOffset), (double)1.0, (double)128.0);
    }

    private void updateSoundSource() {
        SoundTracker.SoundRecord currentNearest = this.findNearestSound();
        if (currentNearest != null) {
            this.targetSoundPos = currentNearest.pos;
            this.safeDistSq = Math.pow(this.calculateSafeDistance(currentNearest.range), 2.0);
        } else {
            this.targetSoundPos = null;
        }
    }

    @Nullable
    private SoundTracker.SoundRecord findNearestSound() {
        Level currentLevel = this.mob.m_9236_();
        if (currentLevel.f_46443_) {
            return null;
        }
        return SoundSystemFacade.findNearestSoundFor((Mob)this.mob);
    }

    private static enum FleeState {
        NOT_FLEEING,
        PANICKING,
        FLEEING,
        PAUSING;

    }
}

