/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound.config;

import com.example.fear_of_sound.FearofSoundMod;
import com.example.fear_of_sound.config.AdvancedFearOverride;
import com.example.fear_of_sound.config.NbtMatchers;
import com.example.fear_of_sound.config.TopLevelCommaSplitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.registries.ForgeRegistries;

public final class AdvancedFearOverrideRegistry {
    private static final Map<EntityType<?>, List<AdvancedFearOverride>> BY_TYPE = new HashMap();
    private static final List<AdvancedFearOverride> WILDCARD = new ArrayList<AdvancedFearOverride>();

    private AdvancedFearOverrideRegistry() {
    }

    public static void clear() {
        BY_TYPE.clear();
        WILDCARD.clear();
    }

    public static void rebuild(List<? extends String> raw) {
        AdvancedFearOverrideRegistry.clear();
        if (raw == null || raw.isEmpty()) {
            return;
        }
        int ok = 0;
        int bad = 0;
        for (String string : raw) {
            String trimmed;
            if (string == null || (trimmed = string.trim()).isEmpty()) continue;
            try {
                AdvancedFearOverride rule = AdvancedFearOverrideRegistry.parseLine(trimmed);
                if (rule == null) {
                    ++bad;
                    continue;
                }
                if (rule.entityWildcard) {
                    WILDCARD.add(rule);
                } else {
                    for (EntityType<?> et : rule.entityTypes) {
                        BY_TYPE.computeIfAbsent(et, k -> new ArrayList()).add(rule);
                    }
                }
                ++ok;
            }
            catch (Exception e) {
                ++bad;
                FearofSoundMod.LOGGER.warn("[AdvancedFear] Failed to parse '{}': {}", (Object)trimmed, (Object)e.toString());
            }
        }
        if (ok > 0 || bad > 0) {
            FearofSoundMod.LOGGER.info("[AdvancedFear] Loaded {} advanced overrides ({} malformed).", (Object)ok, (Object)bad);
        }
    }

    @Nullable
    private static AdvancedFearOverride parseLine(String line) {
        String[] parts = line.split(";", 4);
        if (parts.length != 4) {
            FearofSoundMod.LOGGER.warn("[AdvancedFear] Malformed entry (need 4 ';' sections): {}", (Object)line);
            return null;
        }
        String name = parts[0].trim();
        String entitiesPart = parts[1].trim();
        String conditionsPart = parts[2].trim();
        String soundsPart = parts[3].trim();
        boolean entityWildcard = entitiesPart.equals("*");
        HashSet entityTypes = new HashSet();
        if (!entityWildcard) {
            List<String> tokens = TopLevelCommaSplitter.split(entitiesPart);
            for (String t : tokens) {
                ResourceLocation rl = ResourceLocation.m_135820_((String)t.trim());
                if (rl == null) {
                    FearofSoundMod.LOGGER.warn("[AdvancedFear] Invalid entity id '{}' in '{}'.", (Object)t, (Object)line);
                    continue;
                }
                EntityType et = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl);
                if (et == null) {
                    FearofSoundMod.LOGGER.warn("[AdvancedFear] Unknown entity '{}' in '{}'.", (Object)rl, (Object)line);
                    continue;
                }
                entityTypes.add(et);
            }
            if (entityTypes.isEmpty()) {
                FearofSoundMod.LOGGER.warn("[AdvancedFear] No valid entities; rule will be ignored: {}", (Object)line);
                return null;
            }
        }
        ArrayList<CompoundTag> nbtMatchers = new ArrayList<CompoundTag>();
        ArrayList<Predicate<Mob>> predicates = new ArrayList<Predicate<Mob>>();
        if (!conditionsPart.isEmpty() && !conditionsPart.equals("-")) {
            List<String> tokens = TopLevelCommaSplitter.split(conditionsPart);
            for (String token : tokens) {
                String t = token.trim();
                Predicate<Mob> pred = AdvancedFearOverrideRegistry.parseComparatorPredicate(t);
                if (pred != null) {
                    predicates.add(pred);
                    continue;
                }
                try {
                    CompoundTag tag = TagParser.m_129359_((String)t);
                    nbtMatchers.add(tag);
                }
                catch (Exception e) {
                    FearofSoundMod.LOGGER.warn("[AdvancedFear] Bad condition token '{}' in '{}': {}", new Object[]{t, line, e.getMessage()});
                }
            }
        }
        boolean soundWildcard = soundsPart.equals("*");
        HashSet<ResourceLocation> soundIds = new HashSet<ResourceLocation>();
        if (!soundWildcard) {
            List<String> tokens = TopLevelCommaSplitter.split(soundsPart);
            for (String t : tokens) {
                ResourceLocation rl = ResourceLocation.m_135820_((String)t.trim());
                if (rl == null) {
                    FearofSoundMod.LOGGER.warn("[AdvancedFear] Invalid sound id '{}' in '{}'.", (Object)t, (Object)line);
                    continue;
                }
                soundIds.add(rl);
            }
            if (soundIds.isEmpty()) {
                FearofSoundMod.LOGGER.warn("[AdvancedFear] No valid sounds; rule will be ignored: {}", (Object)line);
                return null;
            }
        }
        return new AdvancedFearOverride(name, entityTypes, entityWildcard, nbtMatchers, predicates, soundIds, soundWildcard);
    }

    private static Predicate<Mob> parseComparatorPredicate(String t) {
        String s = t.replace(" ", "");
        String[] ops = new String[]{"<=", ">=", "<", ">"};
        String key = null;
        String op = null;
        String rhs = null;
        for (String candidate : ops) {
            int idx = s.indexOf(candidate);
            if (idx <= 0) continue;
            key = s.substring(0, idx);
            op = candidate;
            rhs = s.substring(idx + candidate.length());
            break;
        }
        if (key == null || op == null || rhs == null) {
            return null;
        }
        try {
            if ("health".equalsIgnoreCase(key)) {
                double val = Double.parseDouble(rhs);
                switch (op) {
                    case "<=": {
                        return mob -> (double)mob.m_21223_() <= val;
                    }
                    case ">=": {
                        return mob -> (double)mob.m_21223_() >= val;
                    }
                    case "<": {
                        return mob -> (double)mob.m_21223_() < val;
                    }
                    case ">": {
                        return mob -> (double)mob.m_21223_() > val;
                    }
                }
            } else if ("health_pct".equalsIgnoreCase(key)) {
                double val;
                double valCaptured = val = Double.parseDouble(rhs);
                String opCaptured = op;
                return mob -> {
                    float max = mob.m_21233_();
                    if (max <= 0.0f) {
                        return false;
                    }
                    double pct = mob.m_21223_() / max;
                    return switch (opCaptured) {
                        case "<=" -> {
                            if (pct <= valCaptured) {
                                yield true;
                            }
                            yield false;
                        }
                        case ">=" -> {
                            if (pct >= valCaptured) {
                                yield true;
                            }
                            yield false;
                        }
                        case "<" -> {
                            if (pct < valCaptured) {
                                yield true;
                            }
                            yield false;
                        }
                        case ">" -> {
                            if (pct > valCaptured) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> false;
                    };
                };
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static boolean shouldFear(Mob mob, @Nullable ResourceLocation soundId) {
        if (BY_TYPE.isEmpty() && WILDCARD.isEmpty()) {
            return true;
        }
        ArrayList<AdvancedFearOverride> rules = new ArrayList<AdvancedFearOverride>(WILDCARD);
        List<AdvancedFearOverride> specific = BY_TYPE.get(mob.m_6095_());
        if (specific != null) {
            rules.addAll(specific);
        }
        if (rules.isEmpty()) {
            return true;
        }
        CompoundTag mobNbt = null;
        for (AdvancedFearOverride r : rules) {
            boolean conditionsPass;
            if (!r.soundWildcard && (soundId == null || !r.soundIds.contains(soundId))) continue;
            if ((r.nbtMatchers == null || r.nbtMatchers.isEmpty()) && (r.predicates == null || r.predicates.isEmpty())) {
                conditionsPass = true;
            } else {
                boolean any = false;
                if (r.predicates != null) {
                    for (Predicate<Mob> p : r.predicates) {
                        if (!p.test(mob)) continue;
                        any = true;
                        break;
                    }
                }
                if (!any && r.nbtMatchers != null && !r.nbtMatchers.isEmpty()) {
                    if (mobNbt == null) {
                        mobNbt = mob.m_20240_(new CompoundTag());
                    }
                    for (CompoundTag matcher : r.nbtMatchers) {
                        if (!NbtMatchers.partialMatch(mobNbt, matcher)) continue;
                        any = true;
                        break;
                    }
                }
                conditionsPass = any;
            }
            if (!conditionsPass) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnyRuleFor(EntityType<?> type) {
        if (type == null) {
            return !WILDCARD.isEmpty();
        }
        return !WILDCARD.isEmpty() || BY_TYPE.containsKey(type);
    }
}

