/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.example.fear_of_sound.FearofSoundMod;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigAutoUpdater {
    private static final String FILE_NAME = "fear_of_sound-common.toml";

    public static void migrateIfNeeded() {
        try {
            String adv;
            String behavior;
            String perf;
            Path configPath = FMLPaths.CONFIGDIR.get().resolve(FILE_NAME);
            if (!Files.exists(configPath, new LinkOption[0])) {
                return;
            }
            Path backupPath = configPath.resolveSibling("fear_of_sound-common.toml.bak");
            try {
                Files.copy(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            CommentedFileConfig cfg = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().autosave().build();
            cfg.load();
            boolean changed = false;
            if (!cfg.contains("Line-of-sight fear parameters.losRange")) {
                cfg.set("Line-of-sight fear parameters.losRange", (Object)32);
                cfg.setComment("Line-of-sight fear parameters.losRange", "Fallback LOS radius (in blocks) used when Sound Attract does not provide a detection range.");
                changed = true;
            }
            if (!cfg.contains((perf = "Performance") + ".maxSoundsTracked")) {
                cfg.set(perf + ".maxSoundsTracked", (Object)512);
                cfg.setComment(perf + ".maxSoundsTracked", "Maximum number of sounds to keep in memory when Sound Attract is absent. Older/weaker sounds are evicted when exceeded.");
                changed = true;
            }
            if (!cfg.contains(perf + ".raycastCacheTtlTicks")) {
                cfg.set(perf + ".raycastCacheTtlTicks", (Object)40);
                cfg.setComment(perf + ".raycastCacheTtlTicks", "How long (ticks) to keep block muffling (raycast) results cached.");
                changed = true;
            }
            if (!cfg.contains(perf + ".raycastCacheMaxEntries")) {
                cfg.set(perf + ".raycastCacheMaxEntries", (Object)4096);
                cfg.setComment(perf + ".raycastCacheMaxEntries", "Maximum LRU size for block muffling cache entries across all dimensions.");
                changed = true;
            }
            if (!cfg.contains(perf + ".spatialGridSize")) {
                cfg.set(perf + ".spatialGridSize", (Object)32);
                cfg.setComment(perf + ".spatialGridSize", "Cell size in blocks for the simple spatial index used when Sound Attract is absent.");
                changed = true;
            }
            if (!cfg.contains(perf + ".mergeRadius")) {
                cfg.set(perf + ".mergeRadius", (Object)3);
                cfg.setComment(perf + ".mergeRadius", "Radius in blocks within which identical sounds are de-duplicated by refreshing lifetime instead of adding a new record.");
                changed = true;
            }
            if (!cfg.contains((behavior = "Sound Behavior") + ".panicMinTicks")) {
                cfg.set(behavior + ".panicMinTicks", (Object)0);
                cfg.setComment(behavior + ".panicMinTicks", "Initial panic delay minimum (ticks) before a mob starts fleeing. Set 0 for immediate flee.");
                changed = true;
            }
            if (!cfg.contains(behavior + ".panicMaxTicks")) {
                cfg.set(behavior + ".panicMaxTicks", (Object)0);
                cfg.setComment(behavior + ".panicMaxTicks", "Initial panic delay maximum (ticks). If max > min, a random value in [min, max) is used.");
                changed = true;
            }
            if (!cfg.contains((adv = "Advanced Fear Overrides") + ".fearofsoundadvance")) {
                cfg.set(adv + ".fearofsoundadvance", Collections.emptyList());
                cfg.setComment(adv + ".fearofsoundadvance", String.join((CharSequence)"\n", "Advanced conditional rules that gate whether a mob fears a sound.", "Format: name;entities;nbt_or_predicates;sounds", "- entities/sounds: comma-separated resource locations or '*'", "- nbt_or_predicates: OR list of SNBT objects or predicates (health<=X, health>=X, health<X, health>X, health_pct<=p)", "Examples:", "  low_health_any;*;health_pct<=0.30;*", "  low_health_bell_fear;minecraft:zombie, minecraft:skeleton;health<=8;minecraft:block.bell.use", "  baby_cows_bell;minecraft:cow;{Age:-2147483648};minecraft:block.bell.use", "  zombie_low_hp_tacz;minecraft:zombie;health_pct<0.30;tacz:gun"));
                changed = true;
            }
            if (changed) {
                cfg.save();
                FearofSoundMod.LOGGER.info("[FearOfSound] Auto-updated config with new keys. A backup was saved as {}", (Object)backupPath.getFileName());
            }
            cfg.close();
        }
        catch (Throwable t) {
            FearofSoundMod.LOGGER.error("[FearOfSound] Failed to auto-update config.", t);
        }
    }
}

