/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound.config;

import java.util.ArrayList;
import java.util.List;

public final class TopLevelCommaSplitter {
    private TopLevelCommaSplitter() {
    }

    public static List<String> split(String input) {
        ArrayList<String> out = new ArrayList<String>();
        if (input == null) {
            return out;
        }
        String s = input.trim();
        if (s.isEmpty()) {
            return out;
        }
        StringBuilder current = new StringBuilder();
        int brace = 0;
        int bracket = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inQuotes) {
                current.append(c);
                if (c != quoteChar) continue;
                int backslashes = 0;
                for (int j = i - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
                    ++backslashes;
                }
                if (backslashes % 2 != 0) continue;
                inQuotes = false;
                quoteChar = '\u0000';
                continue;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    inQuotes = true;
                    quoteChar = c;
                    current.append(c);
                    continue block8;
                }
                case '{': {
                    ++brace;
                    current.append(c);
                    continue block8;
                }
                case '}': {
                    if (brace > 0) {
                        --brace;
                    }
                    current.append(c);
                    continue block8;
                }
                case '[': {
                    ++bracket;
                    current.append(c);
                    continue block8;
                }
                case ']': {
                    if (bracket > 0) {
                        --bracket;
                    }
                    current.append(c);
                    continue block8;
                }
                case ',': {
                    if (brace == 0 && bracket == 0) {
                        String token = current.toString().trim();
                        if (!token.isEmpty()) {
                            out.add(token);
                        }
                        current.setLength(0);
                        continue block8;
                    }
                    current.append(c);
                    continue block8;
                }
                default: {
                    current.append(c);
                }
            }
        }
        String last = current.toString().trim();
        if (!last.isEmpty()) {
            out.add(last);
        }
        return out;
    }
}

