/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound.integration;

import com.example.fear_of_sound.SoundTracker;
import com.example.fear_of_sound.config.AdvancedFearOverrideRegistry;
import com.example.fear_of_sound.config.FearofSoundConfig;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundAttractIntegration {
    public static void sendSound(ResourceLocation soundId, double x, double y, double z, ResourceLocation dimension, Optional<UUID> sourcePlayerUUID, int range, double weight) {
        try {
            Class<?> networkClass = Class.forName("com.example.soundattract.network.SoundAttractNetwork");
            Object networkInstance = networkClass.getField("INSTANCE").get(null);
            if (networkInstance == null) {
                return;
            }
            Class<?> messageClass = Class.forName("com.example.soundattract.network.SoundMessage");
            Object msg = messageClass.getConstructor(ResourceLocation.class, Double.TYPE, Double.TYPE, Double.TYPE, ResourceLocation.class, Optional.class, Integer.TYPE, Double.TYPE).newInstance(soundId, x, y, z, dimension, sourcePlayerUUID, range, weight);
            networkClass.getMethod("sendToServer", messageClass).invoke(networkInstance, msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SoundTracker.SoundRecord findNearestSound(Mob mob) {
        try {
            ResourceLocation sid;
            FearofSoundConfig.SoundConfig fearConfig;
            Class<?> trackerClass = Class.forName("com.example.soundattract.tracking.SoundTracker");
            if (trackerClass == null) {
                return null;
            }
            Level level = mob.m_9236_();
            BlockPos mobPos = mob.m_20183_();
            Vec3 mobEyePos = mob.m_146892_();
            Object attractSound = trackerClass.getMethod("findNearestSound", Mob.class, Level.class, BlockPos.class, Vec3.class).invoke(null, mob, level, mobPos, mobEyePos);
            if (attractSound == null) {
                return null;
            }
            Class<?> soundRecordClass = Class.forName("com.example.soundattract.tracking.SoundTracker$SoundRecord");
            SoundEvent soundEventKey = (SoundEvent)soundRecordClass.getField("sound").get(attractSound);
            double finalRange = (Double)soundRecordClass.getField("range").get(attractSound);
            double finalWeight = (Double)soundRecordClass.getField("weight").get(attractSound);
            if ((finalRange <= 0.0 || finalWeight <= 0.0) && soundEventKey != null && FearofSoundConfig.SOUND_CONFIGS_CACHE.containsKey(soundEventKey) && (fearConfig = FearofSoundConfig.SOUND_CONFIGS_CACHE.get(soundEventKey)) != null) {
                finalRange = fearConfig.range;
                finalWeight = fearConfig.weight;
            }
            if (finalWeight <= 0.0) {
                return null;
            }
            ResourceLocation resourceLocation = sid = soundEventKey != null ? ForgeRegistries.SOUND_EVENTS.getKey((Object)soundEventKey) : null;
            if (!AdvancedFearOverrideRegistry.shouldFear(mob, sid)) {
                return null;
            }
            BlockPos pos = BlockPos.m_274446_((Position)((Vec3)soundRecordClass.getField("pos").get(attractSound)));
            int ticksRemaining = (Integer)soundRecordClass.getField("ticksRemaining").get(attractSound);
            String dimensionKey = (String)soundRecordClass.getField("dimensionKey").get(attractSound);
            return new SoundTracker.SoundRecord(soundEventKey, pos, ticksRemaining, dimensionKey, finalRange, finalWeight);
        }
        catch (Exception e) {
            return null;
        }
    }
}

