/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound.integration;

import com.example.fear_of_sound.FearofSoundMod;
import com.example.fear_of_sound.SoundTracker;
import com.example.fear_of_sound.ai.FearSignals;
import com.example.fear_of_sound.config.FearofSoundConfig;
import com.example.fear_of_sound.integration.SoundAttractIntegration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fear_of_sound", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoundAttractLOSIntegration {
    private static final double LOS_SOUND_WEIGHT = 10.0;
    private static boolean SA_MISSING_WARNED = false;
    private static final boolean FOV_EVENTS_PRESENT = SoundAttractLOSIntegration.isFovEventsPresent();
    private static boolean SA_PRESENT_LOGGED = false;
    private static final boolean USE_MOB_TICK = true;
    private static final Map<UUID, Integer> PLAYER_CURSORS = new ConcurrentHashMap<UUID, Integer>();
    private static long LAST_TICK_FOR_CAP = Long.MIN_VALUE;
    private static int PROCESSED_THIS_TICK = 0;

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent event) {
        Vec3 toPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)livingEntity;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (FearofSoundConfig.AFFECTED_ENTITY_TYPES_CACHE.isEmpty()) {
            return;
        }
        if (!FearofSoundConfig.AFFECTED_ENTITY_TYPES_CACHE.contains(mob.m_6095_())) {
            return;
        }
        int interval = Math.max(1, FearofSoundConfig.LOS_CHECK_INTERVAL_TICKS_CACHE);
        int cap = FearofSoundConfig.LOS_PER_TICK_CAP_CACHE;
        long time = level2.m_46467_();
        if (LAST_TICK_FOR_CAP != time) {
            LAST_TICK_FOR_CAP = time;
            PROCESSED_THIS_TICK = 0;
        }
        if (cap > 0 && PROCESSED_THIS_TICK >= cap) {
            return;
        }
        int hash = mob.m_20148_().hashCode() & Integer.MAX_VALUE;
        if ((time + (long)hash) % (long)interval != 0L) {
            return;
        }
        int simDistBlocks = level2.m_7654_().m_6846_().m_11312_() * 16;
        int SCAN_RANGE = FOV_EVENTS_PRESENT ? Math.min(simDistBlocks, Math.max(16, FearofSoundConfig.LOS_SCAN_RANGE_CAP_CACHE)) : 32;
        Player nearest = level2.m_45930_((Entity)mob, (double)SCAN_RANGE);
        if (nearest == null || !nearest.m_6084_()) {
            return;
        }
        double earlyRange = Math.min(32.0, (double)FearofSoundConfig.LOS_SCAN_RANGE_CAP_CACHE);
        if (mob.m_20280_((Entity)nearest) > earlyRange * earlyRange) {
            return;
        }
        Vec3 look = mob.m_20154_().m_82541_();
        if (look.m_82526_(toPlayer = nearest.m_20182_().m_82520_(0.0, (double)nearest.m_20192_() / 2.0, 0.0).m_82546_(mob.m_146892_()).m_82541_()) < 0.5) {
            return;
        }
        double saEffectiveRange = -1.0;
        if (FOV_EVENTS_PRESENT) {
            try {
                Class<?> stealthClass = Class.forName("com.example.soundattract.event.StealthDetectionEvents");
                boolean detectable = (Boolean)stealthClass.getMethod("canMobDetectPlayer", Mob.class, Player.class).invoke(null, mob, nearest);
                if (!detectable) {
                    return;
                }
                saEffectiveRange = (Double)stealthClass.getMethod("getRealisticStealthDetectionRange", Player.class, Mob.class, Level.class).invoke(null, nearest, mob, level2);
            }
            catch (Exception e) {
                return;
            }
        } else {
            boolean detectable = SoundAttractLOSIntegration.isTargetInFovFallback((Mob)mob, (Entity)nearest, true);
            if (!detectable) {
                return;
            }
        }
        String dimKey = level2.m_46472_().m_135782_().toString();
        BlockPos playerPos = BlockPos.m_274446_((Position)nearest.m_20182_());
        int radiusToUse = FearofSoundConfig.LOS_RANGE_CACHE;
        if (FOV_EVENTS_PRESENT && saEffectiveRange > 0.0) {
            int saRangeInt = (int)Math.max(0L, Math.round(saEffectiveRange));
            radiusToUse = Math.max(1, saRangeInt);
        }
        int LOS_COOLDOWN = FearofSoundConfig.LOS_COOLDOWN_CACHE;
        FearSignals.trigger(mob, playerPos, radiusToUse, level2.m_46467_());
        if (!FearofSoundMod.isSoundAttractLoaded) {
            SoundTracker.addSound(null, playerPos, dimKey, radiusToUse, 10.0, LOS_COOLDOWN);
        } else {
            ResourceLocation fosLosId = new ResourceLocation("fear_of_sound", "los");
            ResourceLocation dimId = level2.m_46472_().m_135782_();
            SoundAttractIntegration.sendSound(fosLosId, nearest.m_20185_(), nearest.m_20186_(), nearest.m_20189_(), dimId, Optional.of(nearest.m_20148_()), radiusToUse, 10.0);
        }
        ++PROCESSED_THIS_TICK;
    }

    private static boolean isFovEventsPresent() {
        try {
            Class.forName("com.example.soundattract.event.FovEvents", false, SoundAttractLOSIntegration.class.getClassLoader());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isTargetInFovFallback(Mob looker, Entity target, boolean checkObstructions) {
        double horizontalFovDegrees = 120.0;
        double verticalFovDegrees = 90.0;
        if (checkObstructions && !SoundAttractLOSIntegration.hasVisualLineOfSightFallback(looker, target)) {
            return false;
        }
        return SoundAttractLOSIntegration.isWithinFieldOfViewFallback(looker, target, horizontalFovDegrees, verticalFovDegrees);
    }

    private static boolean hasVisualLineOfSightFallback(Mob looker, Entity target) {
        Vec3 startVec = looker.m_146892_();
        Vec3 endVec = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0);
        ClipContext context = new ClipContext(startVec, endVec, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)looker);
        BlockHitResult hitResult = looker.m_9236_().m_45547_(context);
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private static boolean isWithinFieldOfViewFallback(Mob looker, Entity target, double horizontalFovDegrees, double verticalFovDegrees) {
        Vec3 targetHorizontal;
        Vec3 lookVector = looker.m_20154_();
        Vec3 toTargetVector = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() / 2.0, 0.0).m_82546_(looker.m_146892_()).m_82541_();
        Vec3 lookHorizontal = new Vec3(lookVector.f_82479_, 0.0, lookVector.f_82481_).m_82541_();
        double dotHorizontal = lookHorizontal.m_82526_(targetHorizontal = new Vec3(toTargetVector.f_82479_, 0.0, toTargetVector.f_82481_).m_82541_());
        double angleHorizontal = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dotHorizontal))));
        if (angleHorizontal > horizontalFovDegrees / 2.0) {
            return false;
        }
        double pitchLook = Math.toDegrees(Math.asin(lookVector.f_82480_));
        double pitchTarget = Math.toDegrees(Math.asin(Math.max(-1.0, Math.min(1.0, toTargetVector.f_82480_))));
        double angleVertical = Math.abs(pitchTarget - pitchLook);
        return angleVertical <= verticalFovDegrees / 2.0;
    }

    private static /* synthetic */ boolean lambda$onLevelTick$0(PathfinderMob m) {
        return FearofSoundConfig.AFFECTED_ENTITY_TYPES_CACHE.contains(m.m_6095_());
    }
}

