/*
 * Decompiled with CFR 0.152.
 */
package com.example.fear_of_sound.integration;

import com.example.fear_of_sound.SoundNetwork;
import com.example.fear_of_sound.VoiceChatMessage;
import com.example.fear_of_sound.config.FearofSoundConfig;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.ClientSoundEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;

@ForgeVoicechatPlugin
public class VoiceChatIntegration
implements VoicechatPlugin {
    private static final String VOICE_CHAT_PLUGIN_ID = "fear_of_sound_vc_integration";

    public String getPluginId() {
        return VOICE_CHAT_PLUGIN_ID;
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(ClientSoundEvent.class, this::onClientSound);
    }

    public void onClientSound(ClientSoundEvent event) {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (clientPlayer == null || clientWorld == null || !FearofSoundConfig.VOICE_CHAT_DETECTION_ENABLED_CACHE) {
            return;
        }
        short[] rawAudio = event.getRawAudio();
        if (rawAudio == null || rawAudio.length == 0) {
            return;
        }
        double db = VoiceChatIntegration.computePeakDb(rawAudio);
        double normDb = db - -127.0;
        double factor = 0.0;
        List rawMap = (List)FearofSoundConfig.COMMON.voiceChatDbThresholdMap.get();
        if (rawMap != null && !rawMap.isEmpty()) {
            ArrayList<double[]> pairs = new ArrayList<double[]>();
            for (String entry : rawMap) {
                String[] parts;
                if (entry == null || entry.isEmpty() || (parts = entry.split(":", 2)).length != 2) continue;
                try {
                    double th = Double.parseDouble(parts[0].trim());
                    double mul = Double.parseDouble(parts[1].trim());
                    pairs.add(new double[]{th, mul});
                }
                catch (Exception exception) {}
            }
            Collections.sort(pairs, new Comparator<double[]>(){

                @Override
                public int compare(double[] a, double[] b) {
                    return Double.compare(b[0], a[0]);
                }
            });
            for (double[] p : pairs) {
                if (!(normDb >= p[0])) continue;
                factor = p[1];
                break;
            }
        } else {
            factor = normDb >= 50.0 ? 1.0 : (normDb >= 30.0 ? 0.7 : (normDb >= 10.0 ? 0.3 : 0.0));
        }
        boolean isWhispering = event.isWhispering();
        int baseRange = isWhispering ? (Integer)FearofSoundConfig.COMMON.voiceChatWhisperRange.get() : (Integer)FearofSoundConfig.COMMON.voiceChatNormalRange.get();
        int effectiveRange = (int)Math.round((double)baseRange * factor);
        if (effectiveRange <= 0) {
            return;
        }
        double weight = (Double)FearofSoundConfig.COMMON.voiceChatWeight.get();
        double x = clientPlayer.m_20185_();
        double y = clientPlayer.m_20186_();
        double z = clientPlayer.m_20189_();
        ResourceLocation dim = clientWorld.m_46472_().m_135782_();
        Optional<UUID> sourcePlayerUUID = Optional.of(clientPlayer.m_20148_());
        VoiceChatMessage msg = new VoiceChatMessage(x, y, z, dim, sourcePlayerUUID, effectiveRange, weight);
        SoundNetwork.INSTANCE.sendToServer((Object)msg);
    }

    private static double computePeakDb(short[] samples) {
        int highest = 0;
        for (short s : samples) {
            int a = Math.abs(s);
            if (a <= highest) continue;
            highest = (short)a;
        }
        if (highest == 0) {
            return -127.0;
        }
        double norm = (double)Math.abs(highest) / 32768.0;
        double db = 20.0 * Math.log10(norm);
        if (!Double.isFinite(db)) {
            return -127.0;
        }
        if (db > 0.0) {
            db = 0.0;
        }
        if (db < -127.0) {
            db = -127.0;
        }
        return db;
    }
}

