/*
 * Decompiled with CFR 0.152.
 */
package dorkix.mods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dorkix.mods.NetheriteCompassMod;
import dorkix.mods.components.DebrisTrackingComponent;
import dorkix.mods.netherite_compass.item.NetheriteCompass;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10480;
import net.minecraft.class_11566;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class NetheriteCompassState
extends class_10480 {
    public static final MapCodec<NetheriteCompassState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)true).forGetter(rec$ -> ((NetheriteCompassState)((Object)((Object)((Object)rec$)))).method_65661())).apply((Applicative)instance, NetheriteCompassState::new));
    private final class_10480.class_10481 aimedAngler;
    private final class_10480.class_10481 aimlessAngler;
    private final class_5819 random = class_5819.method_43047();

    public NetheriteCompassState(boolean wobble) {
        super(wobble);
        this.aimedAngler = this.method_65660(0.8f);
        this.aimlessAngler = this.method_65660(0.8f);
    }

    protected float method_65654(class_1799 stack, class_638 world, int seed, @Nullable class_11566 context) {
        class_1309 user;
        boolean isTracking = ((DebrisTrackingComponent)stack.method_58695(NetheriteCompassMod.DEBRIS_TRACKING_COMPONENT, (Object)DebrisTrackingComponent.DEFAULT)).isTracking();
        long time = world.method_8510();
        if (!isTracking) {
            return NetheriteCompassState.getSpinningAngle(time);
        }
        class_1309 class_13092 = user = context != null ? context.method_72393() : null;
        if (user == null) {
            return this.getAimlessAngle(seed, time);
        }
        class_4208 globalPos = NetheriteCompass.getTrackedPos(stack);
        return !NetheriteCompassState.canPointTo((class_1297)user, globalPos) ? this.getAimlessAngle(seed, time) : this.getAngleTo((class_1297)user, time, globalPos.comp_2208());
    }

    private static float getSpinningAngle(long time) {
        Long t = time % 32L;
        return t.floatValue() / 32.0f;
    }

    private float getAimlessAngle(int seed, long time) {
        if (this.aimlessAngler.method_65665(time)) {
            this.aimlessAngler.method_65666(time, this.random.method_43057());
        }
        float f = this.aimlessAngler.method_65664() + (float)NetheriteCompassState.scatter(seed) / 2.1474836E9f;
        return class_3532.method_15341((float)f, (float)1.0f);
    }

    private float getAngleTo(class_1297 entity, long time, class_2338 pos) {
        class_1657 playerEntity;
        float f = (float)NetheriteCompassState.getAngleTo(entity, pos);
        float g = NetheriteCompassState.getBodyYaw(entity);
        if (entity instanceof class_1657 && (playerEntity = (class_1657)entity).method_7340() && playerEntity.method_73183().method_54719().method_54751()) {
            if (this.aimedAngler.method_65665(time)) {
                this.aimedAngler.method_65666(time, 0.5f - (g - 0.25f));
            }
            float h = f + this.aimedAngler.method_65664();
            return class_3532.method_15341((float)h, (float)1.0f);
        }
        float h = 0.5f - (g - 0.25f - f);
        return class_3532.method_15341((float)h, (float)1.0f);
    }

    private static boolean canPointTo(class_1297 entity, @Nullable class_4208 pos) {
        return pos != null && pos.comp_2207() == entity.method_73183().method_27983() && !(pos.comp_2208().method_19770((class_2374)entity.method_73189()) < (double)1.0E-5f);
    }

    private static double getAngleTo(class_1297 entity, class_2338 pos) {
        class_243 vec3d = class_243.method_24953((class_2382)pos);
        return Math.atan2(vec3d.method_10215() - entity.method_23321(), vec3d.method_10216() - entity.method_23317()) / 6.2831854820251465;
    }

    private static float getBodyYaw(class_1297 entity) {
        return class_3532.method_15341((float)(entity.method_73188() / 360.0f), (float)1.0f);
    }

    private static int scatter(int seed) {
        return seed * 1327217883;
    }
}

