/*
 * Decompiled with CFR 0.152.
 */
package dorkix.mods.netherite_compass.item;

import dorkix.mods.NetheriteCompassMod;
import dorkix.mods.components.DebrisTrackingComponent;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class NetheriteCompass
extends class_1792 {
    public static final String ANCIENT_DEBRIS_POS_KEY = "AncientDebrisPos";
    public static final String ANCIENT_DEBRIS_DIMENSION_KEY = "AncientDebrisDimension";
    public static final String ANCIENT_DEBRIS_TRACKED_KEY = "AncientDebrisTracked";

    @Nullable
    public static class_4208 getTrackedPos(class_1799 stack) {
        DebrisTrackingComponent trackingComponent = (DebrisTrackingComponent)stack.method_58695(NetheriteCompassMod.DEBRIS_TRACKING_COMPONENT, (Object)DebrisTrackingComponent.DEFAULT);
        if (trackingComponent.isTracking() && trackingComponent.target().isPresent()) {
            return trackingComponent.target().get();
        }
        return null;
    }

    private static Optional<class_2338> findAncientDebris(class_1799 stack, class_1937 world, class_1297 entity, boolean force) {
        if (world.field_9236) {
            return Optional.empty();
        }
        class_4208 trackedPos = NetheriteCompass.getTrackedPos(stack);
        if (!force && trackedPos != null) {
            class_2680 trackedBlock = world.method_8320(trackedPos.comp_2208());
            if (trackedBlock.method_26204() == class_2246.field_22109) {
                return Optional.of(trackedPos.comp_2208());
            }
            Optional<class_5321<class_1937>> dimKey = NetheriteCompass.getTrackedDimension(stack);
            if (dimKey.isPresent() && dimKey.get() != entity.method_37908().method_27983()) {
                return Optional.empty();
            }
        }
        class_2338 entPos = entity.method_24515();
        Optional<class_2338> closest = NetheriteCompass.findAncientDebrisInNearbyChunks(world, entPos, NetheriteCompassMod.config.chunkRadius);
        NetheriteCompass.playSoundOnStateChange(world, entity, stack, closest);
        NetheriteCompass.writeComponent(stack, (class_5321<class_1937>)world.method_27983(), closest);
        if (force) {
            NetheriteCompass.setTooltip(stack, world, entity);
        }
        return closest;
    }

    private static Optional<class_5321<class_1937>> getTrackedDimension(class_1799 stack) {
        DebrisTrackingComponent trackingComponent = (DebrisTrackingComponent)stack.method_58695(NetheriteCompassMod.DEBRIS_TRACKING_COMPONENT, (Object)DebrisTrackingComponent.DEFAULT);
        if (trackingComponent.isTracking() && trackingComponent.target().isPresent()) {
            return Optional.of(trackingComponent.target().get().comp_2207());
        }
        return Optional.empty();
    }

    private static void playSoundOnStateChange(class_1937 world, class_1297 entity, class_1799 stack, Optional<class_2338> closest) {
        if (closest.isPresent()) {
            NetheriteCompass.playSound(world, entity, true);
            return;
        }
        class_4208 trackedPos = NetheriteCompass.getTrackedPos(stack);
        if (!closest.isPresent() && trackedPos != null) {
            NetheriteCompass.playSound(world, entity, false);
        }
    }

    private static void writeComponent(class_1799 itemStack, class_5321<class_1937> worldKey, Optional<class_2338> closest) {
        if (closest.isPresent()) {
            itemStack.method_57379(NetheriteCompassMod.DEBRIS_TRACKING_COMPONENT, (Object)new DebrisTrackingComponent(true, Optional.of(class_4208.method_19443(worldKey, (class_2338)closest.get()))));
        } else {
            itemStack.method_57379(NetheriteCompassMod.DEBRIS_TRACKING_COMPONENT, (Object)DebrisTrackingComponent.DEFAULT);
        }
    }

    private static void playSound(class_1937 world, class_1297 entity, boolean success) {
        world.method_8396(null, entity.method_24515(), success ? class_3417.field_23199 : class_3417.field_15102, class_3419.field_15248, 1.0f, 1.0f);
    }

    private static Optional<class_2338> findAncientDebrisInNearbyChunks(class_1937 world, class_2338 entPos, int chunkRadius) {
        chunkRadius = Math.max(0, chunkRadius);
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        class_1923 chunkPos = world.method_8500(entPos).method_12004();
        for (int x = chunkPos.field_9181 - chunkRadius; x <= chunkPos.field_9181 + chunkRadius; ++x) {
            for (int z = chunkPos.field_9180 - chunkRadius; z <= chunkPos.field_9180 + chunkRadius; ++z) {
                world.method_8497(x, z).method_51525(blockState -> blockState.method_26204() == class_2246.field_22109, (pos, blockState) -> blocks.add(class_2338.method_49637((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())));
            }
        }
        return NetheriteCompass.getClosestBlockPos(blocks, entPos);
    }

    private static Optional<class_2338> getClosestBlockPos(HashSet<class_2338> blocks, class_2338 entPos) {
        Optional min = blocks.stream().min((entry1, entry2) -> {
            double dist2;
            double dist1 = NetheriteCompass.GetDistance(entPos, entry1);
            return dist1 < (dist2 = NetheriteCompass.GetDistance(entPos, entry2)) ? -1 : (dist1 > dist2 ? 1 : 0);
        });
        return min.isPresent() ? Optional.of((class_2338)min.get()) : Optional.empty();
    }

    private static double GetDistance(class_2338 playerPos, class_2338 entityPos) {
        return playerPos.method_10262((class_2382)entityPos);
    }

    public NetheriteCompass(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (!stack.method_31574(NetheriteCompassMod.NETHERITE_COMPASS)) {
            return class_1269.field_5811;
        }
        user.method_7357().method_62835(stack, 100);
        Optional<class_2338> pos = NetheriteCompass.findAncientDebris(stack, world, (class_1297)user, true);
        NetheriteCompass.playSound(world, (class_1297)user, pos.isPresent());
        return class_1269.field_5812.method_61393(stack);
    }

    public static void setTooltip(class_1799 itemStack, class_1937 world, class_1297 entity) {
        DebrisTrackingComponent trackingComponent = (DebrisTrackingComponent)itemStack.method_58695(NetheriteCompassMod.DEBRIS_TRACKING_COMPONENT, (Object)DebrisTrackingComponent.DEFAULT);
        if (NetheriteCompass.getTrackedPos(itemStack) != null) {
            Optional<class_5321<class_1937>> dimKey = NetheriteCompass.getTrackedDimension(itemStack);
            if (dimKey.isPresent() && dimKey.get() != world.method_27983()) {
                NetheriteCompass.setWrongDimensionLore(itemStack);
            } else {
                NetheriteCompass.setLockedOnLore(itemStack, entity);
            }
        } else if (!trackingComponent.isTracking()) {
            NetheriteCompass.setLocatingLore(itemStack);
        }
    }

    public static class_2561 getHintText() {
        return class_2561.method_43471((String)"item.netherite_compass.netherite_compass.hint").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1080));
    }

    public static void setWrongDimensionLore(class_1799 stack) {
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(NetheriteCompass.getHintText(), class_2561.method_43471((String)"item.netherite_compass.netherite_compass.wrong_dim1").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1079)), class_2561.method_43471((String)"item.netherite_compass.netherite_compass.wrong_dim2").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1079)))));
    }

    public static void setLockedOnLore(class_1799 stack, class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_4208 trackedPos = NetheriteCompass.getTrackedPos(stack);
            if (trackedPos != null) {
                double distance = Math.sqrt(player.method_24515().method_10262((class_2382)trackedPos.comp_2208()));
                int roundedDistance = (int)Math.ceil(distance);
                String distanceKey = roundedDistance == 1 ? "item.netherite_compass.netherite_compass.distance.single" : "item.netherite_compass.netherite_compass.distance.multiple";
                stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(NetheriteCompass.getHintText(), class_2561.method_43471((String)"item.netherite_compass.netherite_compass.locked_on").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1061)), class_2561.method_43469((String)distanceKey, (Object[])new Object[]{roundedDistance}).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1063)))));
                return;
            }
        }
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(NetheriteCompass.getHintText(), class_2561.method_43471((String)"item.netherite_compass.netherite_compass.locked_on").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1061)))));
    }

    public static void setLocatingLore(class_1799 stack) {
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43471((String)"item.netherite_compass.netherite_compass.not_found").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10982(Boolean.valueOf(false)).method_10977(class_124.field_1064)))));
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, class_1304 slot) {
        NetheriteCompass.findAncientDebris(stack, (class_1937)world, entity, false);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (slot != class_1304.field_6173 && slot != class_1304.field_6171 && player.field_7512 == player.field_7498) {
                NetheriteCompass.setTooltip(stack, (class_1937)world, entity);
            }
        }
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        if (!newStack.method_7960() && player.method_37908() != null) {
            NetheriteCompass.setTooltip(newStack, player.method_37908(), (class_1297)player);
        }
        return super.allowComponentsUpdateAnimation(player, hand, oldStack, newStack);
    }
}

