/*
 * Decompiled with CFR 0.152.
 */
package dorkix.mods.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/netherite_compass.json");
    public int chunkRadius = 1;

    public static ModConfig load() {
        ModConfig modConfig;
        if (!CONFIG_FILE.exists()) {
            ModConfig defaultConfig = new ModConfig();
            defaultConfig.save();
            return defaultConfig;
        }
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            ModConfig config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            config.chunkRadius = Math.clamp((long)config.chunkRadius, 1, 16);
            modConfig = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new ModConfig();
            }
        }
        reader.close();
        return modConfig;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

