/*
 * Decompiled with CFR 0.152.
 */
package io.dorkix.netherite_compass;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.dorkix.netherite_compass.DebrisTrackingComponent;
import io.dorkix.netherite_compass.NetheriteCompass;
import io.dorkix.netherite_compass.items.NetheriteCompassItem;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class NetheriteCompassState
extends NeedleDirectionHelper {
    public static final MapCodec<NetheriteCompassState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)true).forGetter(rec$ -> ((NetheriteCompassState)((Object)((Object)((Object)rec$)))).wobble())).apply((Applicative)instance, NetheriteCompassState::new));
    private final NeedleDirectionHelper.Wobbler wobbler;
    private final NeedleDirectionHelper.Wobbler noTargetWobbler;
    private final RandomSource random = RandomSource.create();

    public NetheriteCompassState(boolean wobble) {
        super(wobble);
        this.wobbler = this.newWobbler(0.8f);
        this.noTargetWobbler = this.newWobbler(0.8f);
    }

    protected float calculate(ItemStack stack, ClientLevel world, int seed, Entity user) {
        boolean isTracking = ((DebrisTrackingComponent)stack.getOrDefault((DataComponentType)NetheriteCompass.DEBRIS_TRACKING_COMPONENT.get(), (Object)DebrisTrackingComponent.DEFAULT)).isTracking();
        long time = world.getGameTime();
        if (!isTracking) {
            return NetheriteCompassState.getSpinningAngle(time);
        }
        GlobalPos globalPos = NetheriteCompassItem.getTrackedPos(stack);
        return !NetheriteCompassState.canPointTo(user, globalPos) ? this.getAimlessAngle(seed, time) : this.getAngleTo(user, time, globalPos.pos());
    }

    private static float getSpinningAngle(long time) {
        Long t = time % 32L;
        return t.floatValue() / 32.0f;
    }

    private float getAimlessAngle(int seed, long time) {
        if (this.noTargetWobbler.shouldUpdate(time)) {
            this.noTargetWobbler.update(time, this.random.nextFloat());
        }
        float f = this.noTargetWobbler.rotation() + (float)NetheriteCompassState.scatter(seed) / 2.1474836E9f;
        return Mth.positiveModulo((float)f, (float)1.0f);
    }

    private float getAngleTo(Entity entity, long time, BlockPos pos) {
        Player playerEntity;
        float f = (float)NetheriteCompassState.getAngleTo(entity, pos);
        float g = NetheriteCompassState.getBodyYaw(entity);
        if (entity instanceof Player && (playerEntity = (Player)entity).isLocalPlayer() && playerEntity.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(time)) {
                this.wobbler.update(time, 0.5f - (g - 0.25f));
            }
            float h = f + this.wobbler.rotation();
            return Mth.positiveModulo((float)h, (float)1.0f);
        }
        float h = 0.5f - (g - 0.25f - f);
        return Mth.positiveModulo((float)h, (float)1.0f);
    }

    private static boolean canPointTo(Entity entity, @Nullable GlobalPos pos) {
        return pos != null && pos.dimension() == entity.level().dimension() && !(pos.pos().distToCenterSqr((Position)entity.position()) < (double)1.0E-5f);
    }

    private static double getAngleTo(Entity entity, BlockPos pos) {
        Vec3 vec3d = Vec3.atCenterOf((Vec3i)pos);
        return Math.atan2(vec3d.z() - entity.getZ(), vec3d.x() - entity.getX()) / 6.2831854820251465;
    }

    private static float getBodyYaw(Entity entity) {
        return Mth.positiveModulo((float)(entity.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int scatter(int seed) {
        return seed * 1327217883;
    }
}

