/*
 * Decompiled with CFR 0.152.
 */
package io.dorkix.netherite_compass;

import com.mojang.logging.LogUtils;
import io.dorkix.netherite_compass.items.NetheriteCompassItem;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="netherite_compass")
public class NetheriteCompass {
    public static final String MODID = "netherite_compass";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"netherite_compass");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"netherite_compass");
    public static final ResourceKey<Item> NETHERITE_COMPASS_KEY = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"netherite_compass", (String)"netherite_compass"));
    public static final RegistryObject<Item> NETHERITE_COMPASS_ITEM = ITEMS.register("netherite_compass", () -> new NetheriteCompassItem(new Item.Properties().rarity(Rarity.EPIC).fireResistant().stacksTo(1).setId(NETHERITE_COMPASS_KEY)));
    public static final RegistryObject<CreativeModeTab> NETHERITE_COMPASS_TAB = CREATIVE_MODE_TABS.register("netherite_compass_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).title((Component)Component.translatable((String)"item.netherite_compass.netherite_compass")).icon(() -> ((Item)NETHERITE_COMPASS_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> output.accept((ItemLike)NETHERITE_COMPASS_ITEM.get())).build());
    CompassItemPropertyFunction ANGLE_DELEGATE = new CompassItemPropertyFunction((world, stack, entity) -> NetheriteCompassItem.getTrackedPos(stack));

    public NetheriteCompass(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::clientSetup);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)NETHERITE_COMPASS_ITEM.get()), (ResourceLocation)ResourceLocation.parse((String)"angle"), (stack, level, living, id) -> {
            GlobalPos pos = NetheriteCompassItem.getTrackedPos(stack);
            if (pos == null && level != null) {
                return NetheriteCompassItem.getSpinningAngle(level);
            }
            return this.ANGLE_DELEGATE.unclampedCall(stack, level, living, id);
        }));
    }
}

