/*
 * Decompiled with CFR 0.152.
 */
package io.dorkix.netherite_compass.items;

import com.mojang.serialization.DynamicOps;
import io.dorkix.netherite_compass.NetheriteCompass;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class NetheriteCompassItem
extends Item {
    public static final String ANCIENT_DEBRIS_POS_KEY = "AncientDebrisPos";
    public static final String ANCIENT_DEBRIS_DIMENSION_KEY = "AncientDebrisDimension";
    public static final String ANCIENT_DEBRIS_TRACKED_KEY = "AncientDebrisTracked";

    public NetheriteCompassItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public static GlobalPos getTrackedPos(ItemStack stack) {
        Optional<ResourceKey<Level>> worldKey;
        CustomData nbtComponent = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (nbtComponent == null) {
            return null;
        }
        CompoundTag nbt = nbtComponent.copyTag();
        if (nbt == null) {
            return null;
        }
        boolean hasTrackedValue = nbt.contains(ANCIENT_DEBRIS_TRACKED_KEY);
        if (!hasTrackedValue) {
            return null;
        }
        boolean tracked = nbt.getBoolean(ANCIENT_DEBRIS_TRACKED_KEY);
        boolean hasPosKey = nbt.contains(ANCIENT_DEBRIS_POS_KEY);
        boolean hasDimKey = nbt.contains(ANCIENT_DEBRIS_DIMENSION_KEY);
        if (hasPosKey && hasDimKey && tracked && (worldKey = NetheriteCompassItem.getTrackedDimension(stack)).isPresent()) {
            BlockPos blockPos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)nbt, (String)ANCIENT_DEBRIS_POS_KEY).get();
            return GlobalPos.of(worldKey.get(), (BlockPos)blockPos);
        }
        return null;
    }

    private static Optional<BlockPos> findAncientDebris(ItemStack stack, Level level, Entity entity, boolean force) {
        if (level.isClientSide) {
            return Optional.empty();
        }
        GlobalPos trackedPos = NetheriteCompassItem.getTrackedPos(stack);
        NetheriteCompassItem.setTooltip(stack, level);
        if (!force && trackedPos != null) {
            BlockState trackedBlock = level.getBlockState(trackedPos.pos());
            if (trackedBlock.getBlock() == Blocks.ANCIENT_DEBRIS) {
                return Optional.of(trackedPos.pos());
            }
            NetheriteCompassItem.setTooltip(stack, level);
            Optional<ResourceKey<Level>> dimKey = NetheriteCompassItem.getTrackedDimension(stack);
            if (dimKey.isPresent() && !dimKey.get().toString().equals(entity.level().dimension().toString())) {
                return Optional.empty();
            }
        }
        BlockPos entPos = entity.blockPosition();
        Optional<BlockPos> closest = NetheriteCompassItem.findAncientDebrisInNearbyChunks(level, entPos, 1);
        NetheriteCompassItem.playSoundOnStateChange(level, entity, stack, closest);
        NetheriteCompassItem.writeNbt(stack, (ResourceKey<Level>)level.dimension(), closest);
        NetheriteCompassItem.setTooltip(stack, level);
        return closest;
    }

    private static Optional<ResourceKey<Level>> getTrackedDimension(ItemStack stack) {
        CustomData nbtComponent = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (nbtComponent == null) {
            return null;
        }
        CompoundTag nbt = nbtComponent.copyTag();
        return Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(ANCIENT_DEBRIS_DIMENSION_KEY)).result();
    }

    private static void playSoundOnStateChange(Level level, Entity entity, ItemStack stack, Optional<BlockPos> closest) {
        if (closest.isPresent()) {
            NetheriteCompassItem.playSound(level, entity, true);
            return;
        }
        GlobalPos trackedPos = NetheriteCompassItem.getTrackedPos(stack);
        if (!closest.isPresent() && trackedPos != null) {
            NetheriteCompassItem.playSound(level, entity, false);
        }
    }

    private static void writeNbt(ItemStack itemStack, ResourceKey<Level> levelKey, Optional<BlockPos> closest) {
        CustomData nbtComponent = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag nbt = nbtComponent.copyTag();
        if (closest.isPresent()) {
            BlockPos pos = closest.get();
            nbt.put(ANCIENT_DEBRIS_POS_KEY, NbtUtils.writeBlockPos((BlockPos)pos));
            Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, levelKey).resultOrPartial(arg_0 -> ((Logger)NetheriteCompass.LOGGER).error(arg_0)).ifPresent(nbtElement -> nbt.put(ANCIENT_DEBRIS_DIMENSION_KEY, nbtElement));
            nbt.putBoolean(ANCIENT_DEBRIS_TRACKED_KEY, true);
        } else {
            nbt.put(ANCIENT_DEBRIS_POS_KEY, NbtUtils.writeBlockPos((BlockPos)BlockPos.ZERO));
            nbt.putBoolean(ANCIENT_DEBRIS_TRACKED_KEY, false);
            nbt.remove(ANCIENT_DEBRIS_DIMENSION_KEY);
        }
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
    }

    private static void playSound(Level level, Entity entity, boolean success) {
        level.playSound(null, entity.blockPosition(), success ? SoundEvents.LODESTONE_COMPASS_LOCK : SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private static Optional<BlockPos> findAncientDebrisInNearbyChunks(Level level, BlockPos entPos, int chunkRadius) {
        chunkRadius = Math.max(0, chunkRadius);
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        ChunkPos chunkPos = level.getChunk(entPos).getPos();
        for (int x = chunkPos.x - chunkRadius; x <= chunkPos.x + chunkRadius; ++x) {
            for (int z = chunkPos.z - chunkRadius; z <= chunkPos.z + chunkRadius; ++z) {
                level.getChunk(x, z).findBlocks(blockState -> blockState.getBlock() == Blocks.ANCIENT_DEBRIS, (pos, blockState) -> blocks.add(BlockPos.containing((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())));
            }
        }
        return NetheriteCompassItem.getClosestBlockPos(blocks, entPos);
    }

    private static Optional<BlockPos> getClosestBlockPos(HashSet<BlockPos> blocks, BlockPos entPos) {
        Optional min = blocks.stream().min((entry1, entry2) -> {
            double dist2;
            double dist1 = NetheriteCompassItem.GetDistance(entPos, entry1);
            return dist1 < (dist2 = NetheriteCompassItem.GetDistance(entPos, entry2)) ? -1 : (dist1 > dist2 ? 1 : 0);
        });
        return min.isPresent() ? Optional.of((BlockPos)min.get()) : Optional.empty();
    }

    private static double GetDistance(BlockPos playerPos, BlockPos entityPos) {
        return playerPos.distSqr((Vec3i)entityPos);
    }

    public static void setTooltip(ItemStack itemStack, Level level) {
        if (NetheriteCompassItem.getTrackedPos(itemStack) != null) {
            Optional<ResourceKey<Level>> dimKey = NetheriteCompassItem.getTrackedDimension(itemStack);
            if (dimKey.isPresent() && !dimKey.get().toString().equals(level.dimension().toString())) {
                NetheriteCompassItem.setWrongDimensionLore(itemStack);
            } else {
                NetheriteCompassItem.setLockedOnLore(itemStack);
            }
        } else if (itemStack.get(DataComponents.CUSTOM_DATA) != null) {
            NetheriteCompassItem.setLocatingLore(itemStack);
        }
    }

    public static Component getHintText() {
        return Component.translatable((String)"item.netherite_compass.netherite_compass.hint").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withBold(Boolean.valueOf(false)).withColor(ChatFormatting.GRAY));
    }

    public static void setWrongDimensionLore(ItemStack stack) {
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(NetheriteCompassItem.getHintText(), Component.translatable((String)"item.netherite_compass.netherite_compass.wrong_dim1").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withBold(Boolean.valueOf(true)).withColor(ChatFormatting.DARK_RED)), Component.translatable((String)"item.netherite_compass.netherite_compass.wrong_dim2").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withBold(Boolean.valueOf(true)).withColor(ChatFormatting.DARK_RED)))));
    }

    public static void setLockedOnLore(ItemStack stack) {
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(NetheriteCompassItem.getHintText(), Component.translatable((String)"item.netherite_compass.netherite_compass.locked_on").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withBold(Boolean.valueOf(false)).withColor(ChatFormatting.RED)))));
    }

    public static void setLocatingLore(ItemStack stack) {
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"item.netherite_compass.netherite_compass.not_found").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withBold(Boolean.valueOf(false)).withColor(ChatFormatting.DARK_PURPLE)))));
    }

    public static float getSpinningAngle(ClientLevel world) {
        Long t = world.getGameTime() % 32L;
        return t.floatValue() / 32.0f;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        NetheriteCompassItem.findAncientDebris(stack, level, entity, false);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!stack.is((Item)NetheriteCompass.NETHERITE_COMPASS_ITEM.get())) {
            return InteractionResultHolder.pass((Object)stack);
        }
        player.getCooldowns().addCooldown((Item)this, 100);
        Optional<BlockPos> pos = NetheriteCompassItem.findAncientDebris(stack, level, (Entity)player, true);
        NetheriteCompassItem.playSound(level, (Entity)player, pos.isPresent());
        return InteractionResultHolder.success((Object)stack);
    }
}

