/*
 * Decompiled with CFR 0.152.
 */
package dorkix.mods.netherite_compass.item;

import com.mojang.serialization.DynamicOps;
import dorkix.mods.NetheriteCompassMod;
import dorkix.mods.netherite_compass.blockentity.AncientDebrisBlockEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class NetheriteCompass
extends class_1792 {
    public static final String ANCIENT_DEBRIS_POS_KEY = "AncientDebrisPos";
    public static final String ANCIENT_DEBRIS_DIMENSION_KEY = "AncientDebrisDimension";
    public static final String ANCIENT_DEBRIS_TRACKED_KEY = "AncientDebrisTracked";

    @Nullable
    public static class_4208 getTrackedPos(class_2487 nbt) {
        Optional<class_5321<class_1937>> worldKey;
        if (nbt == null) {
            return null;
        }
        boolean hasTrackedValue = nbt.method_10545(ANCIENT_DEBRIS_TRACKED_KEY);
        if (!hasTrackedValue) {
            return null;
        }
        boolean tracked = nbt.method_10577(ANCIENT_DEBRIS_TRACKED_KEY);
        boolean hasPosKey = nbt.method_10545(ANCIENT_DEBRIS_POS_KEY);
        boolean hasDimKey = nbt.method_10545(ANCIENT_DEBRIS_DIMENSION_KEY);
        if (hasPosKey && hasDimKey && tracked && (worldKey = NetheriteCompass.getTrackedDimension(nbt)).isPresent()) {
            class_2338 blockPos = class_2512.method_10691((class_2487)nbt.method_10562(ANCIENT_DEBRIS_POS_KEY));
            return class_4208.method_19443(worldKey.get(), (class_2338)blockPos);
        }
        return null;
    }

    private static Optional<class_2338> findAncientDebris(class_1799 stack, class_1937 world, class_1297 entity, boolean force) {
        if (world.field_9236) {
            return Optional.empty();
        }
        class_4208 trackedPos = NetheriteCompass.getTrackedPos(stack.method_7969());
        if (!force && trackedPos != null) {
            Optional trackedEntity = world.method_35230(trackedPos.method_19446(), NetheriteCompassMod.ANCIENT_DEBRIS_BLOCK_ENTITY);
            if (!trackedEntity.isEmpty()) {
                return Optional.of(trackedPos.method_19446());
            }
            Optional<class_5321<class_1937>> dimKey = NetheriteCompass.getTrackedDimension(stack.method_7969());
            if (dimKey.isPresent() && !dimKey.get().toString().equals(entity.method_37908().method_27983().toString())) {
                return Optional.empty();
            }
        }
        class_2338 entPos = entity.method_24515();
        Optional<class_2338> closest = NetheriteCompass.findAncientDebrisInNearbyChunks(world, entPos, 1);
        NetheriteCompass.playSoundOnStateChange(world, entity, stack, closest);
        NetheriteCompass.writeNbt((class_5321<class_1937>)world.method_27983(), closest, stack.method_7948());
        return closest;
    }

    private static Optional<class_5321<class_1937>> getTrackedDimension(class_2487 nbt) {
        return class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(ANCIENT_DEBRIS_DIMENSION_KEY)).result();
    }

    private static void playSoundOnStateChange(class_1937 world, class_1297 entity, class_1799 stack, Optional<class_2338> closest) {
        if (closest.isPresent()) {
            NetheriteCompass.playSound(world, entity, true);
            return;
        }
        class_4208 trackedPos = NetheriteCompass.getTrackedPos(stack.method_7969());
        if (!closest.isPresent() && trackedPos != null) {
            NetheriteCompass.playSound(world, entity, false);
        }
    }

    private static void writeNbt(class_5321<class_1937> worldKey, Optional<class_2338> closest, class_2487 nbt) {
        if (nbt == null) {
            return;
        }
        if (closest.isPresent()) {
            class_2338 pos = closest.get();
            nbt.method_10566(ANCIENT_DEBRIS_POS_KEY, (class_2520)class_2512.method_10692((class_2338)pos));
            class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, worldKey).resultOrPartial(arg_0 -> ((Logger)NetheriteCompassMod.LOGGER).error(arg_0)).ifPresent(nbtElement -> nbt.method_10566(ANCIENT_DEBRIS_DIMENSION_KEY, nbtElement));
            nbt.method_10556(ANCIENT_DEBRIS_TRACKED_KEY, true);
        } else {
            nbt.method_10566(ANCIENT_DEBRIS_POS_KEY, (class_2520)class_2512.method_10692((class_2338)class_2338.field_10980));
            nbt.method_10556(ANCIENT_DEBRIS_TRACKED_KEY, false);
            nbt.method_10551(ANCIENT_DEBRIS_DIMENSION_KEY);
        }
    }

    private static void playSound(class_1937 world, class_1297 entity, boolean success) {
        world.method_8396(null, entity.method_24515(), success ? class_3417.field_23199 : class_3417.field_15102, class_3419.field_15248, 1.0f, 1.0f);
    }

    private static Optional<class_2338> findAncientDebrisInNearbyChunks(class_1937 world, class_2338 entPos, int chunkRadius) {
        chunkRadius = Math.max(0, chunkRadius);
        HashMap<class_2338, AncientDebrisBlockEntity> entities = new HashMap<class_2338, AncientDebrisBlockEntity>();
        class_1923 chunkPos = world.method_8500(entPos).method_12004();
        for (int x = chunkPos.field_9181 - chunkRadius; x <= chunkPos.field_9181 + chunkRadius; ++x) {
            for (int z = chunkPos.field_9180 - chunkRadius; z <= chunkPos.field_9180 + chunkRadius; ++z) {
                entities.putAll(world.method_8497(x, z).method_12214().entrySet().stream().filter(entry -> entry.getValue() instanceof AncientDebrisBlockEntity).collect(Collectors.toMap(entry -> (class_2338)entry.getKey(), entry -> (AncientDebrisBlockEntity)((Object)((Object)entry.getValue())))));
            }
        }
        return NetheriteCompass.getClosestBlockPos(entities, entPos);
    }

    private static Optional<class_2338> getClosestBlockPos(Map<class_2338, AncientDebrisBlockEntity> entities, class_2338 entPos) {
        Optional min = entities.entrySet().stream().min((entry1, entry2) -> {
            double dist2;
            double dist1 = NetheriteCompass.GetDistance(entPos, (class_2338)entry1.getKey());
            return dist1 < (dist2 = NetheriteCompass.GetDistance(entPos, (class_2338)entry2.getKey())) ? -1 : (dist1 > dist2 ? 1 : 0);
        });
        return min.isPresent() ? Optional.of((class_2338)((Map.Entry)min.get()).getKey()) : Optional.empty();
    }

    private static double GetDistance(class_2338 playerPos, class_2338 entityPos) {
        return playerPos.method_10262((class_2382)entityPos);
    }

    public NetheriteCompass(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            return class_1271.method_22427((Object)user.method_5998(hand));
        }
        user.method_7357().method_7906((class_1792)this, 100);
        Optional<class_2338> pos = NetheriteCompass.findAncientDebris(user.method_6047(), world, (class_1297)user, true);
        NetheriteCompass.playSound(world, (class_1297)user, pos.isPresent());
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        if (tooltipContext.method_47370()) {
            return;
        }
        if (NetheriteCompass.getTrackedPos(itemStack.method_7969()) != null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.netherite_compass.netherite_compass.hint").method_27692(class_124.field_1080));
            Optional<class_5321<class_1937>> dimKey = NetheriteCompass.getTrackedDimension(itemStack.method_7969());
            if (dimKey.isPresent() && !dimKey.get().toString().equals(world.method_27983().toString())) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.netherite_compass.netherite_compass.wrong_dim1").method_27692(class_124.field_1079).method_27692(class_124.field_1067));
                tooltip.add((class_2561)class_2561.method_43471((String)"item.netherite_compass.netherite_compass.wrong_dim2").method_27692(class_124.field_1079).method_27692(class_124.field_1067));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.netherite_compass.netherite_compass.locked_on").method_27692(class_124.field_1061));
            }
        } else if (itemStack.method_7969() != null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.netherite_compass.netherite_compass.not_found").method_27692(class_124.field_1064));
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        NetheriteCompass.findAncientDebris(stack, world, entity, false);
    }
}

