/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodChest;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.core.block.BlockWithEntityGuiTank;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.helper.ParticleHelpers;

public class BlockBloodInfuser
extends BlockWithEntityGuiTank {
    public static final MapCodec<BlockBloodChest> CODEC = BlockBloodInfuser.simpleCodec(BlockBloodChest::new);
    public static final EnumProperty<Direction> FACING = EnumProperty.create((String)"facing", Direction.class, (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");

    public BlockBloodInfuser(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityBloodInfuser::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockBloodInfuser.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_BLOOD_INFUSER.get()), (BlockEntityTicker)(level.isClientSide() ? new BlockEntityTickingTankInventory.TickerClient() : new BlockEntityWorking.TickerServer()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ON});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)ON, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public int getDefaultCapacity() {
        return BlockEntityBloodInfuser.LIQUID_PER_SLOT;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        ParticleHelpers.spawnRandomBloodBubbleParticles((BlockEntityWorking)worldIn.getBlockEntity(pos), worldIn, pos, rand, (Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(stateIn, FACING, (Comparable)Direction.NORTH));
        super.animateTick(stateIn, worldIn, pos, rand);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return IModHelpers.get().getBlockEntityHelpers().get(world, pos, BlockEntityBloodInfuser.class).map(tile -> tile.isVisuallyWorking() ? 4 : super.getLightEmission(state, world, pos)).orElse(0);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, ItemStack toolStack, boolean willHarvest, FluidState fluid) {
        IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, BlockEntityBloodInfuser.class).ifPresent(tile -> {
            EntityHelpers.spawnXpAtPlayer((Level)player.level(), (Player)player, (int)((int)Math.floor(tile.getXp())));
            tile.resetXp();
        });
        return super.onDestroyedByPlayer(state, world, pos, player, toolStack, willHarvest, fluid);
    }
}

