/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.block.BlockWithEntityGui;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;

public class BlockSanguinaryEnvironmentalAccumulator
extends BlockWithEntityGui {
    public static final MapCodec<BlockSanguinaryEnvironmentalAccumulator> CODEC = BlockSanguinaryEnvironmentalAccumulator.simpleCodec(BlockSanguinaryEnvironmentalAccumulator::new);
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");

    public BlockSanguinaryEnvironmentalAccumulator(BlockBehaviour.Properties properties) {
        super(properties, BlockEntitySanguinaryEnvironmentalAccumulator::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ON, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockSanguinaryEnvironmentalAccumulator.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.get()), (BlockEntityTicker)(level.isClientSide() ? new BlockEntitySanguinaryEnvironmentalAccumulator.TickerClient() : new BlockEntityWorking.TickerServer()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ON});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)ON, (Comparable)Boolean.valueOf(false));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return IModHelpers.get().getBlockEntityHelpers().get(world, pos, BlockEntitySanguinaryEnvironmentalAccumulator.class).filter(BlockEntityWorking::isVisuallyWorking).map(tile -> 4).orElseGet(() -> super.getLightEmission(state, world, pos));
    }
}

