/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.ItemAccessItemLocation;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;

public class BlockEntityDarkTank
extends BlockEntityTankInventory {
    public static final int BASE_CAPACITY = 16000;
    @NBTPersist
    private boolean enabled;

    public BlockEntityDarkTank(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_DARK_TANK.get(), blockPos, blockState, 0, 0, 16000, null);
    }

    public double getFillRatio() {
        return Math.min(1.0, (double)this.getTank().getFluidAmount() / (double)this.getTank().getCapacity());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.sendUpdate();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    protected boolean fill(ItemAccess itemAccess) {
        ResourceHandler container = (ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM);
        return !IModHelpersNeoForge.get().getFluidHelpers().move((ResourceHandler)this.getTank(), container, Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount()), null, false, false).isEmpty();
    }

    @Override
    public void onTankChanged() {
        super.onTankChanged();
        this.sendUpdate();
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityDarkTank> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityDarkTank blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            if (!blockEntity.getTank().isEmpty() && blockEntity.isEnabled()) {
                Direction down = Direction.DOWN;
                ResourceHandler handler = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)level, pos.relative(down), (Object)down.getOpposite(), Capabilities.Fluid.BLOCK).orElse(null);
                if (handler != null) {
                    IModHelpersNeoForge.get().getFluidHelpers().move((ResourceHandler)blockEntity.getTank(), handler, Math.min(GeneralConfig.mbFlowRate, blockEntity.getTank().getFluidAmount()), null, false, false);
                } else {
                    List entities = level.getEntitiesOfClass(Entity.class, new AABB(Vec3.atLowerCornerOf((Vec3i)pos.relative(down)), Vec3.atLowerCornerOf((Vec3i)pos.relative(down).offset(1, 1, 1))), EntitySelector.ENTITY_STILL_ALIVE);
                    for (Entity entity : entities) {
                        if (!blockEntity.getTank().isEmpty() && entity instanceof ItemEntity) {
                            ItemEntity item = (ItemEntity)entity;
                            ItemAccess itemAccess = ItemAccess.forStack((ItemStack)item.getItem());
                            if (itemAccess.getCapability(Capabilities.Fluid.ITEM) == null || item.getItem().getCount() != 1 || !blockEntity.fill(itemAccess)) continue;
                            item.setItem(itemAccess.getResource().toStack(itemAccess.getAmount()));
                            continue;
                        }
                        if (!(entity instanceof Player)) continue;
                        Player player = (Player)entity;
                        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
                        while (!blockEntity.getTank().isEmpty() && it.hasNext()) {
                            ItemLocation itemLocation = it.nextIndexed();
                            ItemAccessItemLocation itemAccess = new ItemAccessItemLocation(player, itemLocation);
                            if (itemAccess.getAmount() <= 0 || itemAccess.getCapability(Capabilities.Fluid.ITEM) == null) continue;
                            blockEntity.fill((ItemAccess)itemAccess);
                        }
                    }
                }
            }
        }
    }
}

