/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.fluid.FluidHandlerWrapper;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.network.IPacketHandler;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestal;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestalConfig;
import org.cyclops.evilcraft.core.algorithm.RegionIterator;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.network.packet.SanguinaryPedestalBlockReplacePacket;

public class BlockEntitySanguinaryPedestal
extends BlockEntityTankInventory {
    private static final int MB_RATE = 100;
    public static final int TANK_BUCKETS = 10;
    private static final int OFFSET = 2;
    private static final int OFFSET_EFFICIENCY = 4;
    private static final int ACTIONS_PER_TICK_EFFICIENCY = 5;
    private final ResourceHandler<FluidResource> bonusFluidHandler = new FluidHandlerWrapper((ResourceHandler)this.getTank()){

        public int insert(int slot, FluidResource fluidResource, int amount, TransactionContext transactionContext) {
            if (BlockEntitySanguinaryPedestal.this.hasEfficiency() && amount > 0) {
                amount = (int)((double)amount * BlockSanguinaryPedestalConfig.efficiencyBoost);
            }
            return super.insert(slot, fluidResource, amount, transactionContext);
        }
    };
    private RegionIterator regionIterator;

    public BlockEntitySanguinaryPedestal(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SANGUINARY_PEDESTAL.get(), blockPos, blockState, 0, 1, IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() * 10, (Fluid)RegistryEntries.FLUID_BLOOD.get());
    }

    public ResourceHandler<FluidResource> getBonusFluidHandler() {
        return this.bonusFluidHandler;
    }

    protected void afterBlockReplace(ServerLevel world, BlockPos location) {
        EvilCraft._instance.getPacketHandler().sendToAllAroundPoint((PacketBase)new SanguinaryPedestalBlockReplacePacket(location.getX(), location.getY(), location.getZ()), IPacketHandler.createTargetPointFromLocation((ServerLevel)world, (BlockPos)location, (int)15));
    }

    protected boolean hasEfficiency() {
        return ((BlockSanguinaryPedestal)this.getBlockState().getBlock()).getTier() == 1;
    }

    private BlockPos getNextLocation() {
        if (this.regionIterator == null) {
            this.regionIterator = new RegionIterator(this.getBlockPos(), this.hasEfficiency() ? 4 : 2, true);
        }
        return this.regionIterator.next();
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntitySanguinaryPedestal> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntitySanguinaryPedestal blockEntity) {
            int actions;
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            int n = actions = blockEntity.hasEfficiency() ? 5 : 1;
            while (!blockEntity.getTank().isFull() && actions > 0) {
                BlockPos location = blockEntity.getNextLocation();
                Block block = level.getBlockState(location).getBlock();
                if (block instanceof BlockBloodStain) {
                    IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)level, location, Capabilities.Fluid.BLOCK).ifPresent(source -> {
                        FluidStack moved = IModHelpersNeoForge.get().getFluidHelpers().move(source, blockEntity.getBonusFluidHandler(), Integer.MAX_VALUE, null, false, false);
                        if (!moved.isEmpty()) {
                            blockEntity.afterBlockReplace((ServerLevel)level, location);
                        }
                    });
                }
                --actions;
            }
            if (!blockEntity.getTank().isEmpty()) {
                for (Direction direction : Direction.values()) {
                    IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)level, pos.relative(direction), (Object)direction.getOpposite(), Capabilities.Fluid.BLOCK).ifPresent(handler -> {
                        if (!blockEntity.getTank().isEmpty()) {
                            IModHelpersNeoForge.get().getFluidHelpers().move((ResourceHandler)blockEntity.getTank(), handler, Math.min(100, blockEntity.getTank().getFluidAmount()), null, false, false);
                        }
                    });
                }
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityTankInventory.CapabilityRegistrar<BlockEntitySanguinaryPedestal> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntitySanguinaryPedestal>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void registerTankInventoryCapabilitiesItem() {
        }
    }
}

