/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import org.cyclops.cyclopscore.helper.IFluidHelpersNeoForge;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyInTankTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;

public class EmptyFluidContainerInTankTickAction<T extends BlockEntityTickingTankInventory<T>>
extends EmptyInTankTickAction<T> {
    @Override
    public void onTick(T tile, ItemStack itemStack, int slot, int tick) {
        ItemStack containerStackOriginal = ((BlockEntityTankInventory)((Object)tile)).getInventory().getItem(slot).copy();
        ItemAccess containerItemAccess = ItemAccess.forHandlerIndex((ResourceHandler)VanillaContainerWrapper.of((Container)((BlockEntityTankInventory)((Object)tile)).getInventory()), (int)slot).oneByOne();
        ResourceHandler container = (ResourceHandler)containerItemAccess.getCapability(Capabilities.Fluid.ITEM);
        IFluidHelpersNeoForge fh = IModHelpersNeoForge.get().getFluidHelpers();
        if (container != null && fh.hasFluid(container)) {
            FluidStack moved = fh.move(container, (ResourceHandler)((BlockEntityTankInventory)((Object)tile)).getTank(), MB_PER_TICK, null, false, false);
            if (moved.isEmpty()) {
                moved = fh.move(container, (ResourceHandler)((BlockEntityTankInventory)((Object)tile)).getTank(), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), null, false, false);
            }
            if (!moved.isEmpty() && !containerItemAccess.getResource().is((Object)containerStackOriginal.getItem())) {
                IModHelpers.get().getItemStackHelpers().spawnItemStack(tile.getLevel(), tile.getBlockPos(), containerItemAccess.getResource().toStack());
                ((BlockEntityTankInventory)((Object)tile)).getInventory().setItem(slot, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public float getRequiredTicks(T tile, int slot, int tick) {
        return EmptyFluidContainerInTankTickAction.getRequiredTicks(tile, ((BlockEntityTankInventory)((Object)tile)).getInventory().getItem(slot));
    }

    public static int getRequiredTicks(BlockEntityTankInventory tile, ItemStack itemStack) {
        ResourceHandler container = (ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack));
        int amount = 0;
        if (container != null && IModHelpersNeoForge.get().getFluidHelpers().hasFluid(container)) {
            amount = IModHelpersNeoForge.get().getFluidHelpers().getAmount(IModHelpersNeoForge.get().getFluidHelpers().getFluid(container));
        }
        int capacity = (int)Math.min(IModHelpersNeoForge.get().getFluidHelpers().getCapacity(container), (long)tile.getTank().getFluidAmount());
        return (capacity - amount) / MB_PER_TICK;
    }

    @Override
    public boolean canTick(T tile, ItemStack itemStack, int slot, int tick) {
        boolean emptyContainer = false;
        ItemStack containerStack = ((BlockEntityTankInventory)((Object)tile)).getInventory().getItem(slot);
        ResourceHandler container = (ResourceHandler)containerStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forHandlerIndex((ResourceHandler)VanillaContainerWrapper.of((Container)((BlockEntityTankInventory)((Object)tile)).getInventory()), (int)slot));
        if (container != null && IModHelpersNeoForge.get().getFluidHelpers().hasFluid(container)) {
            FluidStack fluidStack = IModHelpersNeoForge.get().getFluidHelpers().getFluid(container);
            if (IModHelpersNeoForge.get().getFluidHelpers().getAmount(fluidStack) <= 0) {
                emptyContainer = true;
            }
        } else {
            emptyContainer = true;
        }
        return super.canTick(tile, itemStack, slot, tick) && !emptyContainer;
    }
}

