/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.sanguinaryenvironmentalaccumulator;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.block.BlockSanguinaryEnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.blockentity.BlockEntitySanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;

public class AccumulateItemTickAction
implements ITickAction<BlockEntitySanguinaryEnvironmentalAccumulator> {
    @Override
    public boolean canTick(BlockEntitySanguinaryEnvironmentalAccumulator tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.getInventory().getItem(0).isEmpty() && tile.getTileWorkingMetadata().canConsume(tile.getInventory().getItem(0), tile.getLevel())) {
            ItemStack production = tile.getInventory().getItem(tile.getTileWorkingMetadata().getProduceSlot());
            return this.getRecipe(tile).map(recipe -> {
                boolean precondition = false;
                ItemStack willProduce = this.willProduceItem(tile, (RecipeEnvironmentalAccumulator)recipe);
                if (production.isEmpty()) {
                    precondition = true;
                } else if (!willProduce.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)production, (ItemStack)this.willProduceItem(tile, (RecipeEnvironmentalAccumulator)recipe)) && production.getCount() + willProduce.getCount() <= production.getMaxStackSize()) {
                    precondition = true;
                }
                return precondition && tile.canWork() && tile.getVirtualTank().getAmountAsInt(0) >= this.getRequiredFluidAmount(tile, (RecipeEnvironmentalAccumulator)recipe);
            }).orElse(false);
        }
        return false;
    }

    @Override
    public void onTick(BlockEntitySanguinaryEnvironmentalAccumulator tile, ItemStack itemStack, int slot, int tick) {
        RecipeEnvironmentalAccumulator recipe;
        ItemStack result;
        Optional<RecipeEnvironmentalAccumulator> optionalRecipe = this.getRecipe(tile);
        if (optionalRecipe.isPresent() && tick >= this.getRequiredTicks(tile, optionalRecipe.get()) && this.addToProduceSlot(tile, result = (recipe = optionalRecipe.get()).assemble(tile.getInventory(), (HolderLookup.Provider)tile.getLevel().registryAccess()))) {
            tile.getInventory().removeItem(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            try (Transaction tx = Transaction.openRoot();){
                tile.getVirtualTank().extract((Resource)FluidResource.of((FluidStack)tile.getVirtualTank().getFluid()), this.getRequiredFluidAmount(tile, recipe), (TransactionContext)tx);
                tx.commit();
            }
        }
    }

    @Override
    public final float getRequiredTicks(BlockEntitySanguinaryEnvironmentalAccumulator tile, int slot, int tick) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(this.getRecipe(tile).get()));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, BlockEntitySanguinaryEnvironmentalAccumulator.UPGRADEEVENT_SPEED));
        return duration.getValue().intValue();
    }

    public static int getUsage(int baseCooldownTime) {
        return baseCooldownTime * BlockSanguinaryEnvironmentalAccumulatorConfig.baseUsage;
    }

    protected int getRequiredFluidAmount(BlockEntitySanguinaryEnvironmentalAccumulator tile, RecipeEnvironmentalAccumulator recipe) {
        MutableInt amount = new MutableInt(AccumulateItemTickAction.getUsage(recipe.getCooldownTime()));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(amount, BlockEntitySanguinaryEnvironmentalAccumulator.UPGRADEEVENT_BLOODUSAGE));
        return Math.max(1, amount.getValue());
    }

    private Optional<RecipeEnvironmentalAccumulator> getRecipe(BlockEntitySanguinaryEnvironmentalAccumulator tile) {
        return tile.getRecipe(tile.getInventory().getItem(0));
    }

    private int getUnmodifiedRequiredTicks(RecipeEnvironmentalAccumulator recipe) {
        return recipe.getDuration();
    }

    private int getRequiredTicks(BlockEntitySanguinaryEnvironmentalAccumulator tile, RecipeEnvironmentalAccumulator recipe) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(recipe));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, BlockEntitySanguinaryEnvironmentalAccumulator.UPGRADEEVENT_SPEED));
        return duration.getValue();
    }

    protected ItemStack willProduceItem(BlockEntitySanguinaryEnvironmentalAccumulator tile, RecipeEnvironmentalAccumulator recipe) {
        return recipe.assemble(tile.getInventory(), (HolderLookup.Provider)tile.getLevel().registryAccess());
    }

    public boolean addToProduceSlot(BlockEntitySanguinaryEnvironmentalAccumulator tile, ItemStack itemStack) {
        return IModHelpers.get().getInventoryHelpers().addToSlot((Container)tile.getInventory(), tile.getTileWorkingMetadata().getProduceSlot(), itemStack);
    }
}

