/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritReanimator;
import org.cyclops.evilcraft.core.client.gui.container.ContainerScreenTileWorking;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritReanimator;

public class ContainerScreenSpiritReanimator
extends ContainerScreenTileWorking<ContainerSpiritReanimator, BlockEntitySpiritReanimator> {
    public static final int TEXTUREWIDTH = 176;
    public static final int TEXTUREHEIGHT = 166;
    public static final int TANKWIDTH = 16;
    public static final int TANKHEIGHT = 58;
    public static final int TANKX = 176;
    public static final int TANKY = 0;
    public static final int TANKTARGETX = 43;
    public static final int TANKTARGETY = 72;
    public static final int PROGRESSWIDTH = 10;
    public static final int PROGRESSHEIGHT = 24;
    public static final int PROGRESSX = 192;
    public static final int PROGRESSY = 0;
    public static final int PROGRESSTARGETX = 119;
    public static final int PROGRESSTARGETY = 26;
    public static final int PROGRESS_INVALIDX = 192;
    public static final int PROGRESS_INVALIDY = 24;

    public ContainerScreenSpiritReanimator(ContainerSpiritReanimator container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.setTank(16, 58, 176, 0, 43, 72);
        this.setProgress(10, 24, 192, 0, 119, 26);
    }

    @Override
    protected Component getName() {
        return Component.translatable((String)"block.evilcraft.spirit_reanimator");
    }

    public Identifier constructGuiTexture() {
        return Identifier.fromNamespaceAndPath((String)"evilcraft", (String)"textures/gui/spirit_reanimator_gui.png");
    }

    @Override
    protected void drawAdditionalForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String prefix = ((Block)RegistryEntries.BLOCK_SPIRIT_REANIMATOR.get()).getDescriptionId() + ".help.invalid";
        ArrayList lines = Lists.newArrayList();
        lines.add(Component.translatable((String)prefix));
        String entityName = ((ContainerSpiritReanimator)this.getMenu()).getEntityName();
        if (entityName == null) {
            lines.add(Component.translatable((String)(prefix + ".no_entity")));
        } else if (entityName.isEmpty()) {
            lines.add(Component.translatable((String)(prefix + ".invalid_entity")));
        } else {
            ItemStack outputStack = ((ContainerSpiritReanimator)this.getMenu()).getContainerInventory().getItem(3);
            if (!outputStack.isEmpty() && outputStack.getItem() instanceof SpawnEggItem && ((SpawnEggItem)outputStack.getItem()).getType(outputStack) != BuiltInRegistries.ENTITY_TYPE.getValue(Identifier.parse((String)entityName))) {
                lines.add(Component.translatable((String)(prefix + ".different_egg")));
            }
        }
        if (lines.size() > 1) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.getGuiTexture(), 119 + this.offsetX, 26 + this.offsetY, 192.0f, 24.0f, 10, 24, 256, 256);
            if (this.isHovering(119 + this.offsetX, 26 + this.offsetY, 10, 24, mouseX, mouseY)) {
                this.drawTooltip(lines, guiGraphics, mouseX, mouseY);
            }
        }
    }

    @Override
    protected int getProgressXScaled(int width) {
        return width;
    }

    @Override
    protected int getProgressYScaled(int height) {
        return ((ContainerSpiritReanimator)this.getMenu()).getProgress(0) * 24 / ((ContainerSpiritReanimator)this.getMenu()).getMaxProgress(0);
    }
}

