/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.entity.TntRenderer;
import net.minecraft.client.renderer.entity.state.TntRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class RenderBombPrimed
extends TntRenderer {
    protected final BlockRenderDispatcher blockRenderer;
    protected final Block block;

    public RenderBombPrimed(EntityRendererProvider.Context renderContext, Block block) {
        super(renderContext);
        this.blockRenderer = renderContext.getBlockRenderDispatcher();
        this.block = block;
    }

    public void submit(TntRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        super.submit(renderState, poseStack, submitNodeCollector, cameraRenderState);
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5, 0.0);
        if (renderState.fuseRemainingInTicks < 10.0f) {
            float f = 1.0f - renderState.fuseRemainingInTicks / 10.0f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            poseStack.scale(f1, f1, f1);
        }
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        poseStack.translate(-0.5, -0.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        TntMinecartRenderer.submitWhiteSolidBlock((BlockState)this.block.defaultBlockState(), (PoseStack)poseStack, (SubmitNodeCollector)submitNodeCollector, (int)renderState.lightCoords, (renderState.fuseRemainingInTicks / 5.0f % 2.0f == 0.0f ? 1 : 0) != 0, (int)renderState.outlineColor);
        poseStack.popPose();
    }
}

