/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.blockentity.BlockEntityBoxOfEternalClosure;
import org.cyclops.evilcraft.client.render.blockentity.RendererBlockEntityEndPortalBase;
import org.cyclops.evilcraft.client.render.model.ModelBoxOfEternalClosureBaked;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class RenderBlockEntityBoxOfEternalClosure
extends RendererBlockEntityEndPortalBase<BlockEntityBoxOfEternalClosure, RenderState> {
    private static final Identifier beamTexture = Identifier.fromNamespaceAndPath((String)"evilcraft", (String)"textures/entity/beam.png");
    private static final RenderType renderTypeBeam = RenderTypes.entitySmoothCutout((Identifier)beamTexture);

    public RenderBlockEntityBoxOfEternalClosure(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public boolean shouldRender(BlockEntityBoxOfEternalClosure blockEntity, Vec3 cameraPos) {
        return blockEntity.getBlockPos() == BlockPos.ZERO || super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public AABB getRenderBoundingBox(BlockEntityBoxOfEternalClosure blockEntity) {
        return AABB.INFINITE;
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    public void extractRenderState(BlockEntityBoxOfEternalClosure blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.previousLidAngle = blockEntity.getPreviousLidAngle();
        renderState.lidAngle = blockEntity.getLidAngle();
        renderState.partialTicks = partialTick;
        renderState.crystalBeamOffsetY = RenderBlockEntityBoxOfEternalClosure.getY(blockEntity, renderState.partialTicks);
        EntityVengeanceSpirit targetSpirit = blockEntity.getTargetSpirit();
        boolean bl = renderState.hasTarget = targetSpirit != null;
        if (renderState.hasTarget) {
            renderState.target = targetSpirit.position();
            renderState.eyeHeight = targetSpirit.getEyeHeight();
        }
    }

    @Override
    public void submit(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        Direction direction = (Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(renderState.blockState, BlockBoxOfEternalClosure.FACING, (Comparable)Direction.NORTH);
        poseStack.pushPose();
        int rotation = 0;
        if (direction == Direction.SOUTH) {
            rotation = -90;
        }
        if (direction == Direction.NORTH) {
            rotation = 90;
        }
        if (direction == Direction.WEST) {
            rotation = 180;
        }
        if (direction == Direction.EAST) {
            rotation = 0;
        }
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)rotation));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        BlockState blockState = (BlockState)renderState.blockState.setValue(BlockBoxOfEternalClosure.FACING, (Comparable)Direction.NORTH);
        ModelBoxOfEternalClosureBaked model = (ModelBoxOfEternalClosureBaked)IModHelpers.get().getRenderHelpers().getBakedModel(blockState);
        submitNodeCollector.submitCustomGeometry(poseStack, Sheets.solidBlockSheet(), (pose, vertexConsumer) -> ModelBlockRenderer.renderModel((PoseStack.Pose)pose, (VertexConsumer)vertexConsumer, (BlockStateModel)model.getBoxModel(), (float)1.0f, (float)1.0f, (float)1.0f, (int)renderState.lightCoords, (int)OverlayTexture.NO_OVERLAY));
        float angle = renderState.previousLidAngle + (renderState.lidAngle - renderState.previousLidAngle) * renderState.partialTicks;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        poseStack.translate(0.25f, 0.375f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(angle));
        poseStack.translate(-0.25f, -0.375f, 0.0f);
        submitNodeCollector.submitCustomGeometry(poseStack, Sheets.solidBlockSheet(), (pose, vertexConsumer) -> ModelBlockRenderer.renderModel((PoseStack.Pose)pose, (VertexConsumer)vertexConsumer, (BlockStateModel)model.getBoxLidModel(), (float)1.0f, (float)1.0f, (float)1.0f, (int)renderState.lightCoords, (int)OverlayTexture.NO_OVERLAY));
        poseStack.popPose();
        if (angle > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.75f, 0.0f);
            super.submit(renderState, poseStack, submitNodeCollector, cameraRenderState);
            poseStack.popPose();
        }
        poseStack.popPose();
        if (renderState.hasTarget) {
            BlockPos blockpos = renderState.blockPos;
            float f = renderState.crystalBeamOffsetY;
            float f1 = (float)renderState.target.x + 0.5f - (float)blockpos.getX();
            float f2 = (float)renderState.target.y + 0.5f - renderState.eyeHeight / 2.0f - (float)blockpos.getY();
            float f3 = (float)renderState.target.z + 0.5f - (float)blockpos.getZ();
            poseStack.translate(f1, f2, f3);
            EnderDragonRenderer.submitCrystalBeams((float)(-f1), (float)(-f2 + f), (float)(-f3), (float)renderState.partialTicks, (PoseStack)poseStack, (SubmitNodeCollector)submitNodeCollector, (int)renderState.lightCoords);
        }
    }

    @Override
    public boolean shouldRenderFace(Direction direction) {
        return direction == Direction.UP;
    }

    public static float getY(BlockEntityBoxOfEternalClosure p_229051_0_, float p_229051_1_) {
        float f = (float)p_229051_0_.innerRotation + p_229051_1_;
        float f1 = Mth.sin((double)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    @Override
    public void renderCube(Matrix4f pose, VertexConsumer consumer) {
        this.renderFace(pose, consumer, 0.3125f, 0.6875f, -0.5f, -0.5f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }

    public static class RenderState
    extends BlockEntityRenderState {
        public float previousLidAngle;
        public float lidAngle;
        public float partialTicks;
        public float crystalBeamOffsetY;
        public boolean hasTarget;
        public Vec3 target;
        public float eyeHeight;
    }
}

