/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.object.chest.ChestModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.blockentity.state.ChestRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public abstract class RenderBlockEntityChestBase<T extends BlockEntity, S extends RenderState>
implements BlockEntityRenderer<T, S> {
    private final ChestModel singleModel;
    private final boolean xmasTextures = ChestRenderer.xmasTextures();
    protected final MaterialSet materials;

    public RenderBlockEntityChestBase(BlockEntityRendererProvider.Context context) {
        this.singleModel = new ChestModel(context.bakeLayer(ModelLayers.CHEST));
        this.materials = context.materials();
    }

    protected abstract Direction getDirection(S var1);

    protected Material getMaterial(S renderState) {
        return Sheets.chooseMaterial((ChestRenderState.ChestMaterialType)((RenderState)((Object)renderState)).chestMaterialType, (ChestType)ChestType.SINGLE);
    }

    protected void handleRotation(S renderState, PoseStack matrixStack) {
        float f = this.getDirection(renderState).toYRot();
        matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-f));
    }

    public void extractRenderState(T blockEntity, S renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPosition, breakProgress);
        ((RenderState)((Object)renderState)).chestMaterialType = this.xmasTextures ? ChestRenderState.ChestMaterialType.CHRISTMAS : ChestRenderState.ChestMaterialType.REGULAR;
        ((RenderState)((Object)renderState)).openNess = ((LidBlockEntity)blockEntity).getOpenNess(partialTick);
        ((RenderState)((Object)renderState)).openNessRaw = ((LidBlockEntity)blockEntity).getOpenNess(0.0f);
    }

    public void submit(S renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        this.handleRotation(renderState, poseStack);
        poseStack.translate(-0.5, -0.5, -0.5);
        float f1 = ((RenderState)((Object)renderState)).openNess;
        Material material = this.getMaterial(renderState);
        TextureAtlasSprite textureAtlasSprite = this.materials.get(material);
        submitNodeCollector.submitModel((Model)this.singleModel, (Object)Float.valueOf(f1), poseStack, material.renderType(RenderTypes::entityCutout), ((RenderState)((Object)renderState)).lightCoords, OverlayTexture.NO_OVERLAY, -1, textureAtlasSprite, 0, ((RenderState)((Object)renderState)).breakProgress);
        poseStack.popPose();
    }

    public static class RenderState
    extends BlockEntityRenderState {
        public ChestRenderState.ChestMaterialType chestMaterialType;
        public float openNess;
        public float openNessRaw;
    }
}

