/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.Identifier;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cyclops.evilcraft.blockentity.BlockEntityColossalBloodChest;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityChestBase;
import org.jetbrains.annotations.Nullable;

public class RenderBlockEntityColossalBloodChest
extends RenderBlockEntityChestBase<BlockEntityColossalBloodChest, RenderState> {
    private static final Identifier TEXTURE = Identifier.fromNamespaceAndPath((String)"evilcraft", (String)"model/colossal_blood_chest");

    public RenderBlockEntityColossalBloodChest(BlockEntityRendererProvider.Context p_i226008_1_) {
        super(p_i226008_1_);
    }

    @Override
    protected Direction getDirection(RenderState renderState) {
        return renderState.rotation;
    }

    public AABB getRenderBoundingBox(BlockEntityColossalBloodChest blockEntity) {
        return new AABB(Vec3.atLowerCornerOf((Vec3i)blockEntity.getBlockPos().subtract(new Vec3i(3, 3, 3))), Vec3.atLowerCornerOf((Vec3i)blockEntity.getBlockPos().offset(3, 6, 3)));
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    @Override
    public void extractRenderState(BlockEntityColossalBloodChest blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPosition, breakProgress);
        renderState.rotation = blockEntity.getRotation().getOpposite();
        renderState.isStructureComplete = blockEntity.isStructureComplete();
        renderState.renderOffset = blockEntity.getRenderOffset();
        renderState.sizeSingular = blockEntity.getSizeSingular();
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    @Override
    protected void handleRotation(RenderState renderState, PoseStack matrixStack) {
        if (renderState.isStructureComplete) {
            Vec3i renderOffset = renderState.renderOffset;
            matrixStack.translate((float)(-renderOffset.getX()), (float)(-renderOffset.getY()), (float)(-renderOffset.getZ()));
        }
        super.handleRotation(renderState, matrixStack);
        matrixStack.translate(0.0f, (float)renderState.sizeSingular * 0.0625f, 0.0f);
        float size = (float)renderState.sizeSingular * 1.125f;
        matrixStack.scale(size, size, size);
    }

    @Override
    public void submit(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.isStructureComplete) {
            super.submit(renderState, poseStack, submitNodeCollector, cameraRenderState);
        }
    }

    @Override
    protected Material getMaterial(RenderState renderState) {
        return new Material(Sheets.CHEST_SHEET, TEXTURE);
    }

    public static class RenderState
    extends RenderBlockEntityChestBase.RenderState {
        public Direction rotation;
        public boolean isStructureComplete;
        public Vec3i renderOffset;
        public int sizeSingular;
    }
}

